/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.panther.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.base64.Base64;
import ch.randelshofer.quaqua.ext.nanoxml.XMLElement;
import ch.randelshofer.quaqua.ext.nanoxml.XMLParseException;
import ch.randelshofer.quaqua.filechooser.AliasFileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.Files;
import ch.randelshofer.quaqua.util.BinaryPListParser;
import ch.randelshofer.quaqua.util.SequentialDispatcher;
import ch.randelshofer.quaqua.util.Worker;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SidebarListModel
extends AbstractListModel
implements TreeModelListener {
    private static final File sidebarFile = new File(QuaquaManager.getProperty("user.home"), "Library/Preferences/com.apple.sidebarlists.plist");
    private TreePath path;
    private TreeModel model;
    private JFileChooser fileChooser;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private static final File[] defaultUserItems = QuaquaManager.getProperty("os.name").equals("Mac OS X") ? new File[]{null, new File(QuaquaManager.getProperty("user.home"), "Desktop"), new File(QuaquaManager.getProperty("user.home"), "Documents"), new File(QuaquaManager.getProperty("user.home"))} : (QuaquaManager.getProperty("os.name").startsWith("Windows") ? new File[]{null, new File(QuaquaManager.getProperty("user.home"), "Desktop"), new File(QuaquaManager.getProperty("user.home"), "\u684c\u9762"), new File(QuaquaManager.getProperty("user.home"), "My Documents"), new File(QuaquaManager.getProperty("user.home"))} : new File[]{null, new File(QuaquaManager.getProperty("user.home"))});
    private ArrayList userItems = new ArrayList<File>(Arrays.asList(defaultUserItems));
    private Row[] viewToModel = new Row[0];
    private int[] modelToView = new int[0];
    private HashMap systemItemsMap = new HashMap();
    private static final long VALIDATION_TTL = 60000L;
    private long bestBefore;

    public SidebarListModel(JFileChooser fileChooser, TreePath path, TreeModel model) {
        this.fileChooser = fileChooser;
        this.path = path;
        this.model = model;
        model.addTreeModelListener(this);
        this.sortSystemItems();
        this.validate();
    }

    public void dispose() {
        this.model.removeTreeModelListener(this);
    }

    public int getSize() {
        return this.viewToModel.length + this.userItems.size();
    }

    private void sortSystemItems() {
        int i;
        AliasFileSystemTreeModel.Node parent = (AliasFileSystemTreeModel.Node)this.path.getLastPathComponent();
        if (this.viewToModel.length != parent.getChildCount()) {
            this.viewToModel = new Row[parent.getChildCount()];
            this.modelToView = new int[this.viewToModel.length];
        }
        for (i = 0; i < this.viewToModel.length; ++i) {
            this.viewToModel[i] = new Row(i);
        }
        Arrays.sort(this.viewToModel);
        for (i = 0; i < this.viewToModel.length; ++i) {
            this.modelToView[((Row)this.viewToModel[i]).modelIndex] = i;
        }
    }

    public Object getElementAt(int row) {
        return row < this.viewToModel.length ? (AliasFileSystemTreeModel.Node)this.model.getChild(this.path.getLastPathComponent(), this.viewToModel[row].modelIndex) : this.userItems.get(row - this.viewToModel.length);
    }

    public void treeNodesChanged(TreeModelEvent e) {
        if (e.getTreePath().equals(this.path)) {
            int[] indices = e.getChildIndices();
            this.fireContentsChanged(this, this.modelToView[indices[0]], this.modelToView[indices[indices.length - 1]]);
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        if (e.getTreePath().equals(this.path)) {
            this.sortSystemItems();
            int[] indices = e.getChildIndices();
            for (int i = 0; i < indices.length; ++i) {
                int index = this.modelToView[indices[i]];
                this.fireIntervalAdded(this, index, index);
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        if (e.getTreePath().equals(this.path)) {
            int[] indices = e.getChildIndices();
            int[] oldModelToView = (int[])this.modelToView.clone();
            this.sortSystemItems();
            for (int i = 0; i < indices.length; ++i) {
                int index = oldModelToView[indices[i]];
                int offset = 0;
                for (int j = 0; j < i; ++j) {
                    if (oldModelToView[indices[i]] >= index) continue;
                    ++offset;
                }
                this.fireIntervalRemoved(this, index - offset, index - offset);
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
        if (e.getTreePath().equals(this.path)) {
            this.sortSystemItems();
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    public void lazyValidate() {
        if (this.bestBefore < System.currentTimeMillis()) {
            this.validate();
        }
    }

    private void validate() {
        this.bestBefore = Long.MAX_VALUE;
        this.dispatcher.dispatch(new Worker(){

            public Object construct() {
                try {
                    return SidebarListModel.this.read();
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished(Object value) {
                ArrayList freshUserItems;
                if (value instanceof Throwable) {
                    freshUserItems = new ArrayList(defaultUserItems.length);
                    for (int i = 0; i < defaultUserItems.length; ++i) {
                        if (defaultUserItems[i] == null) {
                            freshUserItems.add(null);
                            continue;
                        }
                        if (!defaultUserItems[i].exists()) continue;
                        freshUserItems.add(new FileItem(defaultUserItems[i]));
                    }
                } else {
                    SidebarListModel.this.systemItemsMap = (HashMap)((Object[])value)[0];
                    freshUserItems = (ArrayList)((Object[])value)[1];
                    freshUserItems.add(0, null);
                }
                int systemItemsSize = SidebarListModel.this.model.getChildCount(SidebarListModel.this.path.getLastPathComponent());
                int oldUserItemsSize = SidebarListModel.this.userItems.size();
                SidebarListModel.this.userItems.clear();
                if (oldUserItemsSize > 0) {
                    SidebarListModel.this.fireIntervalRemoved(SidebarListModel.this, systemItemsSize, systemItemsSize + oldUserItemsSize - 1);
                }
                SidebarListModel.this.userItems = freshUserItems;
                if (SidebarListModel.this.userItems.size() > 0) {
                    SidebarListModel.this.fireIntervalAdded(SidebarListModel.this, systemItemsSize, systemItemsSize + oldUserItemsSize - 1);
                }
                SidebarListModel.this.bestBefore = System.currentTimeMillis() + 60000L;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] read() throws IOException {
        if (!Files.canWorkWithAliases()) {
            throw new IOException("Unable to work with aliases");
        }
        HashMap<String, SystemItemInfo> systemItemsMap = new HashMap<String, SystemItemInfo>();
        ArrayList<FileItem> userItems = new ArrayList<FileItem>();
        FileReader reader = null;
        try {
            reader = new FileReader(sidebarFile);
            XMLElement xml = new XMLElement(new HashMap(), false, false);
            try {
                xml.parseFromReader(reader);
            }
            catch (XMLParseException e) {
                xml = new BinaryPListParser().parse(sidebarFile);
            }
            String key2 = "";
            String key3 = "";
            String key5 = "";
            Iterator i0 = xml.iterateChildren();
            while (i0.hasNext()) {
                XMLElement xml1 = (XMLElement)i0.next();
                Iterator i1 = xml1.iterateChildren();
                while (i1.hasNext()) {
                    XMLElement xml4;
                    Iterator i3;
                    XMLElement xml3;
                    Iterator i2;
                    XMLElement xml2 = (XMLElement)i1.next();
                    if (xml2.getName().equals("key")) {
                        key2 = xml2.getContent();
                    }
                    if (xml2.getName().equals("dict") && key2.equals("systemitems")) {
                        i2 = xml2.iterateChildren();
                        while (i2.hasNext()) {
                            xml3 = (XMLElement)i2.next();
                            if (xml3.getName().equals("key")) {
                                key3 = xml3.getContent();
                            }
                            if (!xml3.getName().equals("array") || !key3.equals("VolumesList")) continue;
                            i3 = xml3.iterateChildren();
                            while (i3.hasNext()) {
                                xml4 = (XMLElement)i3.next();
                                if (!xml4.getName().equals("dict")) continue;
                                SystemItemInfo info = new SystemItemInfo();
                                Iterator i4 = xml4.iterateChildren();
                                while (i4.hasNext()) {
                                    XMLElement xml5 = (XMLElement)i4.next();
                                    if (xml5.getName().equals("key")) {
                                        key5 = xml5.getContent();
                                    }
                                    info.sequenceNumber = systemItemsMap.size();
                                    if (xml5.getName().equals("string") && key5.equals("Name")) {
                                        info.name = xml5.getContent();
                                    }
                                    if (!xml5.getName().equals("string") || !key5.equals("Visibility")) continue;
                                    info.isVisible = xml5.getContent().equals("AlwaysVisible");
                                }
                                if (info.name == null) continue;
                                systemItemsMap.put(info.name, info);
                            }
                        }
                    }
                    if (!xml2.getName().equals("dict") || !key2.equals("useritems")) continue;
                    i2 = xml2.iterateChildren();
                    while (i2.hasNext()) {
                        xml3 = (XMLElement)i2.next();
                        i3 = xml3.iterateChildren();
                        while (i3.hasNext()) {
                            xml4 = (XMLElement)i3.next();
                            Iterator i4 = xml4.iterateChildren();
                            while (i4.hasNext()) {
                                byte[] b;
                                File f;
                                XMLElement xml5 = (XMLElement)i4.next();
                                if (xml5.getName().equals("key")) {
                                    key5 = xml5.getContent();
                                }
                                if (xml5.getName().equals("key") || !key5.equals("Alias") || (f = Files.toFile(b = Base64.decode(xml5.getContent()))) == null) continue;
                                userItems.add(new FileItem(f));
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return new Object[]{systemItemsMap, userItems};
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            AliasFileSystemTreeModel.Node o1 = (AliasFileSystemTreeModel.Node)SidebarListModel.this.model.getChild(SidebarListModel.this.path.getLastPathComponent(), row1);
            AliasFileSystemTreeModel.Node o2 = (AliasFileSystemTreeModel.Node)SidebarListModel.this.model.getChild(SidebarListModel.this.path.getLastPathComponent(), row2);
            SystemItemInfo i1 = (SystemItemInfo)SidebarListModel.this.systemItemsMap.get(o1.getUserName());
            SystemItemInfo i2 = (SystemItemInfo)SidebarListModel.this.systemItemsMap.get(o2.getUserName());
            if (i1 != null && i2 != null) {
                return i1.sequenceNumber - i2.sequenceNumber;
            }
            if (i1 != null) {
                return -1;
            }
            if (i2 != null) {
                return 1;
            }
            return row1 - row2;
        }
    }

    private class FileItem
    implements FileInfo {
        private File file;
        private Icon icon;
        private String userName;
        private boolean isTraversable;
        protected int fileLabel = -1;

        public FileItem(File file) {
            this.file = file;
            this.userName = SidebarListModel.this.fileChooser.getName(file);
            this.isTraversable = true;
        }

        public File getFile() {
            return this.file;
        }

        public String getFileKind() {
            return null;
        }

        public int getFileLabel() {
            return -1;
        }

        public long getFileLength() {
            return -1L;
        }

        public Icon getIcon() {
            if (this.icon == null) {
                if (QuaquaManager.getBoolean("FileChooser.speed")) {
                    this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                } else {
                    SidebarListModel.this.dispatcher.dispatch(new Worker(){

                        public Object construct() {
                            return SidebarListModel.this.fileChooser.getIcon(file);
                        }

                        public void finished(Object value) {
                            icon = (Icon)value;
                            SidebarListModel.this.fireContentsChanged(SidebarListModel.this, 0, SidebarListModel.this.getSize() - 1);
                        }
                    });
                    return this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                }
            }
            return this.icon;
        }

        public String getUserName() {
            return this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        public boolean isValidating() {
            return false;
        }
    }

    private static class SystemItemInfo {
        String name = "";
        int sequenceNumber = 0;
        boolean isVisible = true;

        private SystemItemInfo() {
        }
    }
}

