/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.Application;
import com.jhlabs.app.Document;
import com.jhlabs.app.DocumentController;
import com.jhlabs.app.DocumentWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;

public abstract class ApplicationAction
extends AbstractAction {
    private Application application = Application.getInstance();

    public ApplicationAction(String name) {
        this(name, null, null);
        this.application = Application.getInstance();
    }

    public ApplicationAction(String name, ResourceBundle b) {
        this(name, b, null);
    }

    public ApplicationAction(String name, ResourceBundle b, String iconName) {
        if (b != null) {
            try {
                this.putValue("Name", b.getString(name));
            }
            catch (MissingResourceException e) {
                try {
                    this.putValue("Name", b.getString(name + ".shortDesc"));
                }
                catch (MissingResourceException e2) {
                    // empty catch block
                }
            }
            try {
                this.putValue("ShortDescription", b.getString(name + ".shortDesc"));
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                this.putValue("LongDescription", b.getString(name + ".longDesc"));
            }
            catch (MissingResourceException e) {}
        } else {
            this.putValue("Name", this.localize(name));
        }
        this.putValue("int_name", name);
    }

    public Application getApplication() {
        return this.application;
    }

    public Frame getFrame() {
        return this.application.getFrame();
    }

    public JInternalFrame getWindow() {
        return this.getApplication().getCurrentDocumentWindow().getInternalFrame();
    }

    public DocumentController getController() {
        return this.application.getCurrentDocument().getController();
    }

    public Document getDocument() {
        return this.application.getCurrentDocument();
    }

    public DocumentWindow getDocumentWindow() {
        return this.application.getCurrentDocumentWindow();
    }

    public void busyCursor(boolean busy) {
        this.application.busyCursor(busy);
    }

    public String localize(String s) {
        return this.application.localize(s);
    }

    public Icon loadIcon() {
        return this.loadIcon((String)this.getValue("SmallIcon"));
    }

    public Icon loadIcon(String name) {
        try {
            URL url = this.getClass().getResource(name + ".gif");
            return url == null ? null : new ImageIcon(url);
        }
        catch (Exception e) {
            System.out.println("Can't find icon for " + name);
            return null;
        }
    }

    class DefaultIcon
    implements Icon {
        DefaultIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.red);
            g.drawLine(x, y, x + 24, y + 24);
            g.drawLine(x + 24, y, x, y + 24);
        }

        public int getIconWidth() {
            return 24;
        }

        public int getIconHeight() {
            return 24;
        }
    }
}

