/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.ActionHandler;
import com.jhlabs.app.Application;
import com.jhlabs.app.ApplicationAction;
import com.jhlabs.app.Checkable;
import com.jhlabs.app.Document;
import com.jhlabs.app.DocumentWindow;
import com.jhlabs.app.WindowMenuItem;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;

public class DocumentController
extends ActionHandler
implements PropertyChangeListener,
UndoableEditListener {
    protected Application application;
    public Action undoAction;
    public Action redoAction;
    protected Hashtable actionItems = new Hashtable();
    protected Hashtable actionButtons = new Hashtable();
    protected JMenuBar menuBar;
    protected JToolBar toolBar;
    private JMenu actionsMenu;
    private JMenu windowsMenu;
    private JMenu recentFilesMenu;
    public static final Insets noInsets = new Insets(0, 0, 0, 0);
    protected ResourceBundle commonResources = null;
    private Vector documents = new Vector();
    protected Vector toolbarItems;
    protected Application.MenuBarTag menubarItems;

    public DocumentController(Application application) {
        this.nextInChain = application;
        this.application = application;
        this.commonResources = ResourceBundle.getBundle("com.jhlabs.app.CommonResourceBundle");
        application.addPropertyChangeListener(this);
        this.registerActions();
        this.toolbarItems = new Vector();
        if (application.toolbarItems != null) {
            for (int i = 0; i < application.toolbarItems.size(); ++i) {
                String name = (String)application.toolbarItems.elementAt(i);
                if (name == null) {
                    this.toolbarItems.addElement(null);
                    continue;
                }
                Action action = this.getAction(name);
                if (action == null) continue;
                this.toolbarItems.addElement(action);
            }
        }
    }

    public void makeMenuBarAndToolBar() {
        if (this.application.isMDI()) {
            this.toolBar = this.makeToolbar();
            this.menuBar = this.makeMenubar(null);
        }
    }

    public void dispose() {
        this.application.removePropertyChangeListener(this);
    }

    protected void registerActions() {
        this.registerAction(new CloseAction());
        this.registerAction(new SaveAction());
        this.registerAction(new SaveAsAction());
        this.registerAction(new RevertAction());
        this.registerAction(new PrintAction());
        this.undoAction = new UndoAction();
        this.registerAction(this.undoAction);
        this.redoAction = new RedoAction();
        this.registerAction(this.redoAction);
    }

    public void addDocument(Document document) {
        this.documents.addElement(document);
        document.addPropertyChangeListener(this);
        document.addUndoableEditListener(this);
    }

    public void removeDocument(Document document) {
        this.documents.removeElement(document);
        document.removePropertyChangeListener(this);
        document.removeUndoableEditListener(this);
    }

    public Enumeration getDocuments() {
        return this.documents.elements();
    }

    public JFrame getFrame() {
        return this.application.getFrame();
    }

    protected JToolBar makeToolbar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        if (this.toolbarItems != null) {
            for (int i = 0; i < this.toolbarItems.size(); ++i) {
                Action action = (Action)this.toolbarItems.elementAt(i);
                if (action == null) {
                    toolBar.addSeparator();
                    continue;
                }
                JButton b = this.makeToolbarButton(action);
                toolBar.add(b);
            }
        }
        return toolBar;
    }

    protected JButton makeToolbarButton(Action action) {
        String name = (String)action.getValue("Name");
        String tipText = (String)action.getValue("ShortDescription");
        Icon icon = (Icon)action.getValue("SmallIcon");
        JButton b = icon != null ? new JButton(icon) : new JButton(name);
        b.setMargin(noInsets);
        if (tipText == null) {
            tipText = this.localize(name);
        }
        b.setToolTipText(tipText);
        b.addActionListener(action);
        this.actionButtons.put(action, b);
        return b;
    }

    protected JMenuItem addMenuItem(JMenu menu, Action action, char accelerator, char mnemonic) {
        JMenuItem item = super.addMenuItem(menu, action, accelerator, mnemonic);
        Vector v = this.application.getPluginActions();
        v.removeElement(action);
        this.actionItems.put(action, item);
        return item;
    }

    protected JMenuItem makeMenuItem(String label, MenuShortcut ms) {
        JMenuItem item = new JMenuItem(label);
        return item;
    }

    protected JMenuItem makeMenuItem(String label) {
        return this.makeMenuItem(label, null);
    }

    protected JMenuItem makeMenuItem(Action action, MenuShortcut ms) {
        String name = (String)action.getValue("ShortDescription");
        if (name == null) {
            name = (String)action.getValue("Name");
        }
        JMenuItem item = new JMenuItem(action);
        this.actionItems.put(action, item);
        return item;
    }

    public String localize(String name) {
        try {
            return this.commonResources.getString(name);
        }
        catch (MissingResourceException e) {
            return name;
        }
    }

    public void makeMenu(DocumentWindow window, JMenuBar menuBar, JMenu menu, Application.MenuBarTag tag) {
        Enumeration e = tag.elements();
        while (e.hasMoreElements()) {
            String title;
            Application.MenuTag menuTag = (Application.MenuTag)e.nextElement();
            String name = menuTag.name;
            if (menuTag == this.application.SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            if (menuTag instanceof Application.MenuItemTag) {
                title = this.localize(name);
                Application.MenuItemTag mit = (Application.MenuItemTag)menuTag;
                Action action = this.getAction(name);
                if (action != null) {
                    this.addMenuItem(menu, action, mit.shortcut, mit.mnemonic);
                    continue;
                }
                this.addSpecialMenuItem(window, menu, name);
                continue;
            }
            if (!(menuTag instanceof Application.MenuTag)) continue;
            title = this.localize(name);
            JMenu subMenu = new JMenu(title);
            subMenu.setMnemonic(menuTag.mnemonic);
            this.makeMenu(window, menuBar, subMenu, menuTag);
            if (subMenu.getItemCount() == 0 && subMenu != this.windowsMenu) continue;
            if (menu != null) {
                menu.add(subMenu);
                continue;
            }
            menuBar.add(subMenu);
        }
    }

    public JMenuBar makeMenubar(DocumentWindow window) {
        Application.MenuBarTag menuBarTag;
        this.menubarItems = menuBarTag = this.application.menuBarConfig;
        JMenuBar menuBar = new JMenuBar();
        if (menuBarTag != null) {
            this.makeMenu(window, menuBar, null, menuBarTag);
        }
        return menuBar;
    }

    public void addSpecialMenuItem(DocumentWindow window, JMenu menu, String name) {
        if (name.equals("(windows)")) {
            this.windowsMenu = menu;
            WindowsMenuController wmc = new WindowsMenuController(menu);
            this.application.addPropertyChangeListener(wmc);
        } else if (name.equals("(actions)")) {
            Vector v = this.application.getPluginActions();
            if (v != null & v.size() > 0) {
                this.actionsMenu = menu;
                this.setUpActionsMenu();
            }
        } else if (name.equals("(recentFiles)")) {
            this.recentFilesMenu = new JMenu(this.localize("recentFiles"));
            RecentFilesMenuController wmc = new RecentFilesMenuController(this.recentFilesMenu);
            this.application.addPropertyChangeListener(wmc);
            menu.add(this.recentFilesMenu);
        }
    }

    protected void setUpActionsMenu() {
        if (this.actionsMenu != null) {
            Vector v = this.application.getPluginActions();
            if (v != null & v.size() > 0) {
                Hashtable<String, JMenu> groups = new Hashtable<String, JMenu>();
                Collections.sort(v, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    Action action = (Action)e.nextElement();
                    JMenu subMenu = this.actionsMenu;
                    String group = (String)action.getValue("group");
                    if (group != null && (subMenu = (JMenu)groups.get(group)) == null) {
                        subMenu = new JMenu(group);
                        this.actionsMenu.add(subMenu);
                        groups.put(group, subMenu);
                    }
                    subMenu.add(this.makeMenuItem(action, null));
                }
            } else if (this.actionsMenu != null) {
                this.actionsMenu.getParent().remove(this.actionsMenu);
                this.actionsMenu = null;
            }
        }
    }

    public void saveDocument(Document document) {
        File file = document.getFile();
        try {
            document.writeFile(file);
        }
        catch (Throwable e) {
            if (Application.debugLevel > 0) {
                e.printStackTrace();
            }
            Object[] arguments = new Object[]{file.getName(), e.getMessage()};
            String message = MessageFormat.format(this.commonResources.getString("cantSaveFile"), arguments);
            Application.reportException(message, "Error", e);
        }
    }

    public boolean doSave(Document document) {
        if (document.getFile() == null) {
            return this.doSaveAs(document);
        }
        this.saveDocument(document);
        document.setChanged(false);
        this.application.addRecentFile(document.getFile());
        return true;
    }

    public boolean doSaveAs(Document document) {
        File file = null;
        try {
            if (this.application.useFileChooser) {
                JFileChooser fileChooser = this.application.getFileChooser();
                fileChooser.rescanCurrentDirectory();
                if (fileChooser.showSaveDialog(this.application.getFrame()) == 0) {
                    file = fileChooser.getSelectedFile();
                }
            } else {
                String directory = null;
                String fileName = null;
                FileDialog dialog = new FileDialog((Frame)this.application.getFrame(), "File to save", 1);
                dialog.setFile(document.getSaveFilename());
                dialog.setVisible(true);
                directory = dialog.getDirectory();
                fileName = dialog.getFile();
                if (fileName != null) {
                    file = new File(directory, fileName);
                }
            }
            if (file != null) {
                document.setFile(file);
                return this.doSave(document);
            }
        }
        catch (Throwable e) {
            Object[] arguments = new Object[]{file == null ? "<no name>" : file.getName(), e.getMessage() == null ? e.toString() : e.getMessage()};
            String message = MessageFormat.format(this.commonResources.getString("cantSaveFile"), arguments);
            Application.reportException(message, "Error", e);
        }
        return false;
    }

    public void revertDocument(Document document) {
        document.setChanged(false);
    }

    public void doRevert(Document document) {
        Object[] arguments = new Object[]{document.getTitle()};
        String message = "<html>" + UIManager.get("OptionPane.css") + MessageFormat.format(this.commonResources.getString("confirmRevert"), arguments);
        JOptionPane pane = new JOptionPane(message, 2, 2, null);
        JDialog dialog = pane.createDialog(null, "Revert");
        dialog.setVisible(true);
        dialog.dispose();
        Object o = pane.getValue();
        int result = -1;
        if (o != null && o instanceof Integer) {
            result = (Integer)o;
        }
        if (result == 0) {
            this.revertDocument(document);
        }
    }

    public void doPrint(DocumentWindow window) {
    }

    public void setActionText(Action action, String text) {
        JMenuItem item = (JMenuItem)this.actionItems.get(action);
        if (item != null) {
            item.setText(text);
        }
    }

    public void enableAction(Action action, boolean enable) {
        Component button;
        boolean isChecked = action instanceof Checkable ? ((Checkable)((Object)action)).isChecked() : false;
        JMenuItem item = (JMenuItem)this.actionItems.get(action);
        if (item != null) {
            item.setEnabled(enable);
            if (item instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)item).setState(isChecked);
            }
        }
        if ((button = (Component)this.actionButtons.get(action)) != null) {
            button.setEnabled(enable);
            if (button instanceof JToggleButton) {
                ((JToggleButton)button).setEnabled(isChecked);
            }
        }
        action.setEnabled(enable);
    }

    public void enableAction(Action action) {
        this.enableAction(action, action.isEnabled());
    }

    public void enableCommands() {
        try {
            Document document = this.application.getCurrentDocument();
            if (document != null) {
                UndoManager undoManager = document.getUndoManager();
                if (undoManager != null) {
                    ActionHandler a = this;
                    while (a != null) {
                        Enumeration e = a.actions.elements();
                        while (e.hasMoreElements()) {
                            Action action = (Action)e.nextElement();
                            this.enableAction(action);
                        }
                        a = a.nextInChain;
                    }
                    if (undoManager.getLimit() == 1) {
                        this.setActionText(this.undoAction, undoManager.getUndoOrRedoPresentationName());
                        this.setActionText(this.redoAction, undoManager.getUndoOrRedoPresentationName());
                    } else {
                        this.setActionText(this.undoAction, undoManager.getUndoPresentationName());
                        this.setActionText(this.redoAction, undoManager.getRedoPresentationName());
                    }
                }
            } else {
                Enumeration e = this.actions.elements();
                while (e.hasMoreElements()) {
                    Action action = (Action)e.nextElement();
                    this.enableAction(action, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showMessage(String message) {
        this.application.showMessage(message);
    }

    public void showProgress(int percentage) {
        this.application.showProgress(percentage);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        String p = e.getPropertyName();
        if (source instanceof Document || source == this.application) {
            this.enableCommands();
        }
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        Object source = e.getSource();
        if (source instanceof Document) {
            this.enableCommands();
        }
    }

    public void busyCursor(boolean busy) {
        this.application.busyCursor(busy);
    }

    class RedoAction
    extends DocumentAction {
        public RedoAction() {
            super("redo", DocumentController.this.commonResources, "Redo24");
        }

        public boolean isEnabled() {
            Document document = this.getDocument();
            if (document != null && document.undoManager != null) {
                if (document.undoManager.getLimit() == 1) {
                    return document.undoManager.canUndoOrRedo();
                }
                return document.undoManager.canRedo();
            }
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            this.getDocument().doRedo();
            DocumentController.this.enableCommands();
        }
    }

    class UndoAction
    extends DocumentAction {
        public UndoAction() {
            super("undo", DocumentController.this.commonResources, "Undo24");
        }

        public boolean isEnabled() {
            Document document = this.getDocument();
            if (document != null && document.undoManager != null) {
                if (document.undoManager.getLimit() == 1) {
                    return document.undoManager.canUndoOrRedo();
                }
                return document.undoManager.canUndo();
            }
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            this.getDocument().doUndo();
            DocumentController.this.enableCommands();
        }
    }

    class PrintAction
    extends DocumentAction {
        public PrintAction() {
            super("print", DocumentController.this.commonResources, "Print24");
        }

        public void actionPerformed(ActionEvent e) {
            DocumentController.this.doPrint(this.getDocumentWindow());
        }
    }

    class RevertAction
    extends DocumentAction {
        public RevertAction() {
            super("revert", DocumentController.this.commonResources);
        }

        public boolean isEnabled() {
            Document document = this.getDocument();
            return document != null && document.isChanged() && document.getFile() != null;
        }

        public void actionPerformed(ActionEvent e) {
            DocumentController.this.doRevert(this.getDocument());
        }
    }

    class SaveAsAction
    extends DocumentAction {
        public SaveAsAction() {
            super("saveAs", DocumentController.this.commonResources, "SaveAs24");
        }

        public void actionPerformed(ActionEvent e) {
            DocumentController.this.doSaveAs(this.getDocument());
        }
    }

    class SaveAction
    extends DocumentAction {
        public SaveAction() {
            super("save", DocumentController.this.commonResources, "Save24");
        }

        public void actionPerformed(ActionEvent e) {
            DocumentController.this.doSave(this.getDocument());
        }
    }

    class CloseAction
    extends DocumentAction {
        public CloseAction() {
            super("close", DocumentController.this.commonResources);
        }

        public void actionPerformed(ActionEvent e) {
            this.getDocumentWindow().doClose(false);
        }
    }

    abstract class DocumentAction
    extends ApplicationAction {
        public DocumentAction(String name) {
            super(name);
        }

        public DocumentAction(String name, ResourceBundle b) {
            super(name, b);
        }

        public DocumentAction(String name, ResourceBundle b, String iconName) {
            super(name, b, iconName);
        }

        public boolean isEnabled() {
            return this.getDocument() != null;
        }
    }

    class WindowsMenuController
    implements PropertyChangeListener {
        private JMenu menu;

        public WindowsMenuController(JMenu menu) {
            this.menu = menu;
        }

        public void propertyChange(PropertyChangeEvent event) {
            String p = event.getPropertyName();
            if (this.menu != null && p.equals("recentFiles")) {
                for (int i = this.menu.getItemCount() - 1; i >= 0; --i) {
                    JMenuItem item = this.menu.getItem(i);
                    if (!(item instanceof WindowMenuItem)) continue;
                    this.menu.remove(item);
                    ((WindowMenuItem)item).dispose();
                }
                Enumeration e = DocumentController.this.application.getWindows();
                while (e.hasMoreElements()) {
                    DocumentWindow w = (DocumentWindow)e.nextElement();
                    WindowMenuItem item = new WindowMenuItem(w);
                    this.menu.add(item);
                }
            }
        }
    }

    class RecentFilesMenuController
    implements PropertyChangeListener {
        private JMenu menu;

        public RecentFilesMenuController(JMenu menu) {
            this.menu = menu;
        }

        public void propertyChange(PropertyChangeEvent event) {
            String p = event.getPropertyName();
            if (this.menu != null && p.equals("recentFiles")) {
                DocumentController.this.application.makeRecentFilesMenu(this.menu);
            }
        }
    }
}

