/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntHashMap
extends Dictionary
implements Cloneable {
    private Entry[] entries;
    private int count;
    private int threshold;
    private float loadFactor;

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.entries = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new Enumerator(this.entries, true);
    }

    public synchronized Enumeration elements() {
        return new Enumerator(this.entries, false);
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.entries;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        Entry[] tab = this.entries;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(int key) {
        Entry[] tab = this.entries;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object get(Object key) {
        if (!(key instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        return this.get((Integer)key);
    }

    protected void rehash() {
        int oldCapacity = this.entries.length;
        Entry[] oldTable = this.entries;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized Object put(int key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.entries;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new Entry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object put(Object key, Object value) {
        if (!(key instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        return this.put((Integer)key, value);
    }

    public synchronized Object remove(int key) {
        Entry[] tab = this.entries;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public Object remove(Object key) {
        if (!(key instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        return this.remove((Integer)key);
    }

    public synchronized void clear() {
        Entry[] tab = this.entries;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            IntHashMap t = (IntHashMap)super.clone();
            t.entries = new Entry[this.entries.length];
            int i = this.entries.length;
            while (i-- > 0) {
                t.entries[i] = this.entries[i] != null ? (Entry)this.entries[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    class Enumerator
    implements Enumeration {
        boolean keys;
        int index;
        Entry[] entries;
        Entry entry;

        Enumerator(Entry[] entries, boolean keys) {
            this.entries = entries;
            this.keys = keys;
            this.index = entries.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.entries[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.entries[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry e = this.entry;
                this.entry = e.next;
                return this.keys ? new Integer(e.key) : e.value;
            }
            throw new NoSuchElementException();
        }
    }

    class Entry {
        int hash;
        int key;
        Object value;
        Entry next;

        Entry() {
        }

        protected Object clone() {
            Entry entry = new Entry();
            entry.hash = this.hash;
            entry.key = this.key;
            entry.value = this.value;
            entry.next = this.next != null ? (Entry)this.next.clone() : null;
            return entry;
        }
    }
}

