/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class CentreLayout
implements LayoutManager,
Serializable {
    private boolean centreH;
    private boolean centreV;

    public CentreLayout() {
        this(true, true);
    }

    public CentreLayout(boolean centreH, boolean centreV) {
        this.centreH = centreH;
        this.centreV = centreV;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        int count = target.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            return m.getPreferredSize();
        }
        return new Dimension();
    }

    public Dimension minimumLayoutSize(Container target) {
        int count = target.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            return m.getMinimumSize();
        }
        return new Dimension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Dimension size = target.getSize();
            int w = size.width - (insets.left + insets.right);
            int h = size.height - (insets.top + insets.bottom);
            int count = target.getComponentCount();
            for (int i = 0; i < count; ++i) {
                int ch;
                int cy;
                int cw;
                int cx;
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (this.centreH) {
                    cx = (w - d.width) / 2;
                    cw = d.width;
                } else {
                    cx = insets.left;
                    cw = w;
                }
                if (this.centreV) {
                    cy = (h - d.height) / 2;
                    ch = d.height;
                } else {
                    cy = insets.top;
                    ch = h;
                }
                m.setBounds(cx, cy, cw, ch);
            }
        }
    }
}

