/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.beans;

import com.jhlabs.beans.AbstractPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

public class GraphPropertyEditor
extends AbstractPropertyEditor {
    protected Graph graph;

    public GraphPropertyEditor(String name, String property) {
        super(name, property);
    }

    public Component getCustomEditor() {
        this.graph = new Graph();
        return this.graph;
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
        this.graph.setGraph((int[])value);
    }

    public boolean alwaysRefresh() {
        return true;
    }

    class Graph
    extends JComponent {
        private int[] graph;

        Graph() {
        }

        public Dimension getMinimumSize() {
            return new Dimension(258, 258);
        }

        public Dimension getPreferredSize() {
            return new Dimension(258, 258);
        }

        public void setGraph(int[] graph) {
            this.graph = graph;
            this.repaint();
        }

        protected void graph(Graphics2D g, int[] rgb, int shift) {
            GeneralPath p = new GeneralPath();
            for (int x = 0; x < 256; ++x) {
                int y = 255 - (this.graph[x] >> shift & 0xFF) + 1;
                if (x == 0) {
                    p.moveTo(x, y);
                    continue;
                }
                p.lineTo(x, y);
            }
            g.draw(p);
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.graph != null) {
                g.setColor(Color.white);
                g.fillRect(1, 1, 256, 256);
                g.setColor(Color.lightGray);
                g.drawLine(1, 256, 256, 1);
                g.setColor(Color.black);
                g.drawRect(0, 0, 256, 256);
                g.setColor(Color.red);
                this.graph(g2d, this.graph, 16);
                g.setColor(Color.green);
                this.graph(g2d, this.graph, 8);
                g.setColor(Color.blue);
                this.graph(g2d, this.graph, 0);
            }
        }
    }
}

