/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.beans;

import com.jhlabs.beans.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.geom.Point2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class Point2DPropertyEditor
extends AbstractPropertyEditor {
    private Point2DComponent editor;

    public Point2DPropertyEditor(String name, String property) {
        super(name, property);
    }

    public Component getCustomEditor() {
        this.editor = new Point2DComponent();
        Float value = new Float(0.5f);
        Float min = new Float(0.0f);
        Float max = new Float(1.0f);
        Float step = new Float(0.1f);
        this.editor.add(new JLabel("X:"));
        this.editor.x = new JSpinner(new SpinnerNumberModel(value, min, max, step));
        ((JSpinner.DefaultEditor)this.editor.x.getEditor()).getTextField().setColumns(4);
        this.editor.add(this.editor.x);
        this.editor.x.addChangeListener(this);
        this.editor.add(new JLabel("Y:"));
        this.editor.y = new JSpinner(new SpinnerNumberModel(value, min, max, step));
        ((JSpinner.DefaultEditor)this.editor.y.getEditor()).getTextField().setColumns(4);
        this.editor.add(this.editor.y);
        this.editor.y.addChangeListener(this);
        return this.editor;
    }

    public Object getValue() {
        return new Point2D.Float(((SpinnerNumberModel)this.editor.x.getModel()).getNumber().floatValue(), ((SpinnerNumberModel)this.editor.y.getModel()).getNumber().floatValue());
    }

    public void setValue(Object value) {
        Point2D.Float p = (Point2D.Float)value;
        this.editor.x.setValue(new Float(p.x));
        this.editor.y.setValue(new Float(p.y));
    }

    static class Point2DComponent
    extends JPanel {
        public JSpinner x;
        public JSpinner y;

        Point2DComponent() {
        }
    }
}

