/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PointFilter;
import com.jhlabs.xml.XMLUtils;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.Serializable;

public class Brush
implements Cloneable,
Serializable {
    static final long serialVersionUID = 6746504787777579480L;
    public static final int SIMPLE_BRUSH = 0;
    public static final int IMAGE_BRUSH = 1;
    public static final int RANDOM_FRAMES = 0;
    public static final int SEQUENTIAL_FRAMES = 1;
    public static final int PAINT_MASK = 0;
    public static final int PAINT_IMAGE = 1;
    public static final int PAINT_CLONE = 2;
    public static final int PAINT_DAB = 3;
    private String name;
    protected BufferedImage image;
    protected float radius;
    protected float roundness;
    protected float angle;
    protected float softness;
    protected float aspect;
    private int spacing;
    private float rotation;
    private float scale;
    private float tintVariation;
    private int xHotSpot;
    private int yHotSpot;
    private int frames = 1;
    protected int type;
    private int paintMode = 0;
    private int framePolicy = 0;
    private int rate = 0;
    private int fadeOut = 0;
    private int scatter = 0;
    private float opacity = 1.0f;
    private int blendMode = 0;
    private boolean followPath;
    private boolean aligned = true;
    private float pressureSensitivity;
    private float rotationSensitivity;
    private float xTiltSensitivity;
    private float tTiltSensitivity;
    private float tangentialPressureSensitivity;
    private BufferedImageOp[] filters;

    public Brush() {
    }

    public Brush(String imageName) {
        this.type = 1;
        this.image = ImageUtils.createImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(imageName)).getSource());
        this.image = new GrayToAlphaFilter().filter(this.image, this.image);
        this.name = imageName;
    }

    public Brush(String imageName, String fileName) {
        this.type = 1;
        this.image = ImageUtils.createImage(Toolkit.getDefaultToolkit().getImage(fileName).getSource());
        this.image = this.image = new GrayToAlphaFilter().filter(this.image, this.image);
        this.name = imageName;
    }

    public Brush(BufferedImage image) {
        this.type = 1;
        this.image = image;
    }

    public Object clone() {
        try {
            Brush b = (Brush)super.clone();
            b.image = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
            Graphics2D g = b.image.createGraphics();
            g.drawRenderedImage(this.image, null);
            g.dispose();
            return b;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public BufferedImage getImage(int frame) {
        if (this.image == null) {
            return null;
        }
        int w = this.image.getWidth() / this.frames;
        return this.image.getSubimage(w * frame, 0, w, this.image.getHeight());
    }

    protected void sizeChanged() {
    }

    public boolean imageIsTransformed() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.sizeChanged();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.sizeChanged();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAspect(float aspect) {
        this.aspect = aspect;
        this.sizeChanged();
    }

    public float getAspect() {
        return this.aspect;
    }

    public void setRoundness(float roundness) {
        this.roundness = roundness;
        this.sizeChanged();
    }

    public float getRoundness() {
        return this.roundness;
    }

    public void setSoftness(float softness) {
        this.softness = softness;
        this.sizeChanged();
    }

    public float getSoftness() {
        return this.softness;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public void setScatter(int scatter) {
        this.scatter = scatter;
    }

    public int getScatter() {
        return this.scatter;
    }

    public void setXHotSpot(int xHotSpot) {
        this.xHotSpot = xHotSpot;
    }

    public int getXHotSpot() {
        return this.xHotSpot;
    }

    public void setYHotSpot(int yHotSpot) {
        this.yHotSpot = yHotSpot;
    }

    public int getYHotSpot() {
        return this.yHotSpot;
    }

    public int getWidth() {
        return this.image.getWidth() / this.frames;
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void setFrames(int frames) {
        this.frames = frames;
    }

    public int getFrames() {
        return this.frames;
    }

    public void setFramePolicy(int framePolicy) {
        this.framePolicy = framePolicy;
    }

    public int getFramePolicy() {
        return this.framePolicy;
    }

    public void setPaintMode(int paintMode) {
        this.paintMode = paintMode;
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    public void setBlendMode(int blendMode) {
        this.blendMode = blendMode;
    }

    public int getBlendMode() {
        return this.blendMode;
    }

    public void setFollowPath(boolean followPath) {
        this.followPath = followPath;
    }

    public boolean getFollowPath() {
        return this.followPath;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void setTintVariation(float tintVariation) {
        this.tintVariation = tintVariation;
    }

    public float getTintVariation() {
        return this.tintVariation;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public int getRate() {
        return this.rate;
    }

    public void setPressureSensitivity(float pressureSensitivity) {
        this.pressureSensitivity = pressureSensitivity;
    }

    public float getPressureSensitivity() {
        return this.pressureSensitivity;
    }

    public void setRotationSensitivity(float rotationSensitivity) {
        this.rotationSensitivity = rotationSensitivity;
    }

    public float getRotationSensitivity() {
        return this.rotationSensitivity;
    }

    public void setTangentialPressureSensitivitySensitivity(float tangentialPressureSensitivity) {
        this.tangentialPressureSensitivity = tangentialPressureSensitivity;
    }

    public float getTangentialPressureSensitivitySensitivity() {
        return this.tangentialPressureSensitivity;
    }

    public void setAligned(boolean aligned) {
        this.aligned = aligned;
    }

    public boolean isAligned() {
        return this.aligned;
    }

    public void setFilters(BufferedImageOp[] filters) {
        this.filters = filters;
    }

    public BufferedImageOp[] getFilters() {
        return this.filters;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<brush");
        if (this.name != null) {
            sb.append(" name='" + XMLUtils.xmlEscape(this.name) + "'");
        }
        if (this.spacing != 0) {
            sb.append(" spacing='" + this.spacing + "'");
        }
        if (this.scatter != 0) {
            sb.append(" scatter='" + this.scatter + "'");
        }
        if (this.rotation != 0.0f) {
            sb.append(" rotation='" + this.rotation + "'");
        }
        if (this.opacity != 1.0f) {
            sb.append(" opacity='" + this.opacity + "'");
        }
        if (this.tintVariation != 0.0f) {
            sb.append(" tintVariation='" + this.tintVariation + "'");
        }
        if (this.scale != 0.0f) {
            sb.append(" scale='" + this.scale + "'");
        }
        if (!this.aligned) {
            sb.append(" aligned='" + this.aligned + "'");
        }
        if (this.scale != 0.0f) {
            sb.append(" scale='" + this.scale + "'");
        }
        if (this.scale != 0.0f) {
            sb.append(" scale='" + this.scale + "'");
        }
        if (this.fadeOut != 0) {
            sb.append(" fadeOut='" + this.fadeOut + "'");
        }
        if (this.rate != 0) {
            sb.append(" rate='" + this.rate + "'");
        }
        if (this.framePolicy != 0) {
            sb.append(" framePolicy='" + this.framePolicy + "'");
        }
        if (this.paintMode != 0) {
            sb.append(" paintMode='" + this.paintMode + "'");
        }
        sb.append(" type='" + this.type + "'");
        if (this.frames != 1) {
            sb.append(" frames='" + this.frames + "'");
        }
        if (this.blendMode != 0) {
            sb.append(" blendMode='" + this.blendMode + "'");
        }
        if (this.followPath) {
            sb.append(" followPath='" + this.followPath + "'");
        }
        if (this.pressureSensitivity != 1.0f) {
            sb.append(" pressureSensitivity='" + this.pressureSensitivity + "'");
        }
        sb.append("</brush>");
        return sb.toString();
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }

    public static class GrayToAlphaFilter
    extends PointFilter {
        public int filterRGB(int x, int y, int rgb) {
            int a = 255 - (rgb & 0xFF);
            return a << 24;
        }
    }
}

