/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Application;
import com.jhlabs.app.Document;
import com.jhlabs.app.Task;
import com.jhlabs.beans.AbstractPropertyEditor;
import com.jhlabs.beans.PropertySheet;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.FileFormat;
import com.jhlabs.ie.ImageSelection;
import com.jhlabs.ie.ImageTask;
import com.jhlabs.ie.MoveSelectionTask;
import com.jhlabs.ie.Tool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.ie.tool.FilterTool;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.image.FlipFilter;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.util.Memento;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.beans.Beans;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.undo.UndoManager;

public class CompositionDocument
extends Document {
    private Composition composition;
    private transient Vector listeners = null;
    private static int tmpFileIndex = 1;
    private FileFormat fileFormat;
    private Object fileFormatInfo;
    private boolean filtering;
    private Task pendingTask;
    private Tool oldTool;

    public CompositionDocument(Application application) {
        this(application, 32, 32);
        this.undoManager = new UndoManager(){

            public synchronized boolean canUndoOrRedo() {
                return !CompositionDocument.this.isFiltering() && super.canUndoOrRedo();
            }

            public synchronized boolean canUndo() {
                return !CompositionDocument.this.isFiltering() && super.canUndo();
            }

            public synchronized boolean canRedo() {
                return !CompositionDocument.this.isFiltering() && super.canRedo();
            }
        };
        this.undoManager.setLimit(1);
    }

    public CompositionDocument(Application application, int width, int height) {
        this(application, width, height, -1);
    }

    public CompositionDocument(Application application, int width, int height, int color) {
        super(application);
        this.composition = new Composition(width, height, color);
        this.composition.startUpdate();
        this.composition.updateAll();
        this.composition.endUpdate();
    }

    public CompositionDocument(Application application, BufferedImage image) {
        super(application);
        this.composition = new Composition(image);
        this.composition.startUpdate();
        this.composition.updateAll();
        this.composition.endUpdate();
    }

    public void setComposition(Composition composition) {
        this.composition = composition;
    }

    public Composition getComposition() {
        return this.composition;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormatInfo(Object fileFormatInfo) {
        this.fileFormatInfo = fileFormatInfo;
    }

    public Object getFileFormatInfo() {
        return this.fileFormatInfo;
    }

    public void setPendingTask(Task pendingTask) {
        this.pendingTask = pendingTask;
    }

    public Task getPendingTask() {
        return this.pendingTask;
    }

    public void performPendingTask() {
        if (this.pendingTask != null) {
            super.doTask(this.pendingTask);
            this.pendingTask = null;
        }
    }

    public void doTask(Task task) {
        if (this.pendingTask != null) {
            Task t = this.pendingTask;
            this.pendingTask = null;
            super.doTask(t);
        }
        super.doTask(task);
    }

    public int getWidth() {
        return this.composition.getWidth();
    }

    public int getHeight() {
        return this.composition.getHeight();
    }

    public BufferedImage getCompositeImage() {
        return this.composition.getCompositeImage();
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public boolean isFiltering() {
        return this.filtering || this.composition.getPreviewFilter() != null;
    }

    public void readFile(File file) throws IOException {
        String name = file.getName();
        this.composition.startUpdate();
        int index = name.lastIndexOf(46);
        String extension = index < 0 ? "" : name.substring(index).toLowerCase();
        Vector fileFormats = ((CompositionApplication)this.getApplication()).fileFormats;
        boolean ok = false;
        FileInputStream fis = new FileInputStream(file);
        byte[] fileStart = new byte[8];
        ((InputStream)fis).read(fileStart, 0, 8);
        ((InputStream)fis).close();
        Enumeration e = fileFormats.elements();
        while (!ok && e.hasMoreElements()) {
            FileFormat fileFormat = (FileFormat)e.nextElement();
            if (!fileFormat.canRead(extension) && !fileFormat.canRead(fileStart)) continue;
            InputStream in = null;
            try {
                in = new FileInputStream(file);
                if (fileFormat.readImage(file, in, this)) {
                    this.setFileFormat(fileFormat);
                    ok = true;
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                in.close();
            }
            this.fileFormat = fileFormat;
            ok = true;
        }
        if (!ok) {
            Frame f = new Frame();
            Image image = f.getToolkit().getImage(file.getPath());
            MediaTracker tracker = new MediaTracker(f);
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException ex) {
                throw new IOException("Can't read this image format!");
            }
            tracker.removeImage(image, 0);
            if (tracker.isErrorAny()) {
                throw new IOException("Can't read this image format");
            }
            f.dispose();
            this.composition = new Composition(ImageUtils.createImage(image.getSource()));
            this.setFileFormat(null);
            ok = true;
        }
        if (!ok || this.composition == null) {
            throw new IOException("Can't read this image format");
        }
        this.composition.startUpdate();
        this.composition.updateAll();
        this.composition.endUpdate();
        this.setChanged(false);
    }

    public void writeFile(File file) throws IOException {
        if (this.fileFormat == null) {
            throw new IOException("This file format is not supported for writing");
        }
        File tmpFile = new File(file.getParent(), "#ietmp" + tmpFileIndex++);
        File tmpFile2 = new File(file.getParent(), "#ietmp" + tmpFileIndex++);
        OutputStream out = null;
        try {
            this.performPendingTask();
            this.composition.dropFloatingSelection();
            out = new BufferedOutputStream(new FileOutputStream(tmpFile));
            this.fileFormat.writeImage(tmpFile, out, this);
            out.close();
            file.renameTo(tmpFile2);
            tmpFile.renameTo(file);
            tmpFile2.delete();
        }
        catch (IOException e) {
            if (out != null) {
                out.close();
            }
            tmpFile.delete();
            throw e;
        }
        catch (NoClassDefFoundError e) {
            if (out != null) {
                out.close();
            }
            tmpFile.delete();
            throw new IOException("GIF file format is not supported");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (out != null) {
                out.close();
            }
            tmpFile.delete();
            throw new IOException(e.getMessage());
        }
    }

    public String getSaveFilename() {
        String name;
        String string = name = this.file != null ? this.file.getName() : this.getTitle();
        if (this.fileFormat != null) {
            name = this.fileFormat.getSaveFilename(name);
        }
        return name;
    }

    public BufferedImage getSelection() {
        return this.composition.getSelection();
    }

    public Layer getActiveLayer() {
        return this.composition.getActiveLayer();
    }

    public void setActiveLayer(Layer layer) {
        this.composition.setActiveLayer(layer);
        this.getController().enableCommands();
    }

    public BufferedImage getActiveImage() {
        return this.composition.getActiveImage();
    }

    public boolean hasFloatingSelection() {
        return this.composition.hasFloatingSelection();
    }

    public void dropFloatingSelection() {
        this.composition.dropFloatingSelection();
    }

    public ImageTask startUndo(String name) {
        this.performPendingTask();
        return new ImageTask(this.composition, name);
    }

    public void endUndo(ImageTask task) {
        this.doTask(task);
    }

    public void resize(int width, int height, BufferedImageOp scaleFilter) {
        this.performPendingTask();
        this.doTask(new ResizeTask(width, height, scaleFilter));
    }

    public void moveSelection(int dx, int dy, boolean copy) {
        this.doTask(new MoveSelectionTask(this, dx, dy, copy));
    }

    public void doAddLayer(boolean fromSelection, boolean cut) {
        ImageTask task = this.startUndo("Add Layer");
        this.composition.dropFloatingSelection();
        Layer layer = null;
        if (fromSelection) {
            BufferedImage image = this.composition.getSelectedArea(false);
            if (cut) {
                Rectangle bounds;
                if (!this.composition.hasFloatingSelection() && (bounds = this.composition.getSelectedBounds()) != null) {
                    task.saveArea(bounds);
                }
                this.composition.clearSelection();
            }
            layer = this.composition.pasteIntoSelection(image);
        } else {
            layer = this.composition.addNewImageLayer(null);
        }
        this.composition.setActiveLayer(layer);
        this.endUndo(task);
    }

    public void doDuplicateLayer(Layer layer) {
        ImageTask task = this.startUndo("Duplicate Layer");
        BufferedImage image = ImageUtils.cloneImage(layer.getImage());
        this.composition.dropFloatingSelection();
        layer = this.composition.addLayer(image);
        this.composition.setActiveLayer(layer);
        this.endUndo(task);
    }

    public void doRemoveLayer(Layer layer) {
        ImageTask task = this.startUndo("Remove Layer");
        this.composition.dropFloatingSelection();
        this.composition.removeLayer(layer);
        this.endUndo(task);
    }

    public void doMergeLayer(Layer layer) {
        ImageTask task = this.startUndo("Merge Layers");
        this.composition.dropLayer(layer);
        this.endUndo(task);
    }

    public void doReorderLayer(Layer layer, int newIndex, boolean up) {
        ImageTask task = this.startUndo("Reorder Layer");
        this.composition.dropFloatingSelection();
        if (newIndex >= 0) {
            this.composition.moveLayer(layer, newIndex);
        } else if (up) {
            this.composition.moveLayerUp(layer);
        } else {
            this.composition.moveLayerDown(layer);
        }
        this.composition.layerHasChanged(layer);
        this.composition.updateAll();
        this.endUndo(task);
    }

    public void crop() {
        this.doTask(new CropTask());
    }

    public void doCut() {
        this.doCopy(false);
        this.doClear();
    }

    public void doCopy(boolean merged) {
        Composition composition = this.getComposition();
        BufferedImage copyImage = composition.getSelectedArea(merged);
        ImageSelection s = new ImageSelection(copyImage);
        CompositionApplication.clipboard.setContents(s, s);
    }

    public void doPaste() {
        Transferable t = CompositionApplication.clipboard.getContents(this);
        if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image clipping = (Image)t.getTransferData(DataFlavor.imageFlavor);
                ImageTask task = this.startUndo("Paste");
                this.composition.simplifyActiveLayer();
                BufferedImage newImage = ImageUtils.convertImageToARGB(clipping);
                this.composition.startUpdate();
                this.composition.pasteIntoSelection(newImage);
                this.endUndo(task);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doClear() {
        Rectangle bounds;
        ImageTask task = this.startUndo("Clear");
        if (!this.composition.hasFloatingSelection() && (bounds = this.composition.getSelectedBounds()) != null) {
            task.saveArea(bounds);
        }
        this.composition.clearSelection();
        this.endUndo(task);
    }

    public void doSimplifyLayer(Layer layer) {
        ImageTask task = this.startUndo("Simplify");
        this.composition.simplifyLayer(layer);
        this.endUndo(task);
    }

    public boolean makePaintable() {
        Layer layer = this.composition.getActiveLayer();
        if (layer == null) {
            return false;
        }
        if (layer.isPaintable()) {
            return true;
        }
        String message = "<html>" + UIManager.get("OptionPane.css") + this.getApplication().localize("makePaintable");
        JOptionPane pane = new JOptionPane(message, 2, 2, null);
        Object[] optionNames = new String[]{"Simplify", "Cancel"};
        pane.setOptions(optionNames);
        pane.setInitialValue(optionNames[0]);
        JDialog dialog = pane.createDialog(null, "Simplify");
        dialog.setVisible(true);
        dialog.dispose();
        Object o = pane.getValue();
        return ((String)optionNames[0]).equals(o);
    }

    public void filterImage(Object filter) {
        CompositionApplication application = (CompositionApplication)this.getApplication();
        application.busyCursor(true);
        try {
            PreviewFilterCustomizer pfc;
            InputStream is;
            Component c = null;
            boolean usePreview = false;
            FilterTool tool = null;
            String name = filter.getClass().getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            if ((is = filter.getClass().getResourceAsStream(name + ".xml")) != null) {
                pfc = new PreviewFilterCustomizer(new PropertySheet(), usePreview);
                PropertySheet propertySheet = pfc.getPropertySheet();
                propertySheet.loadXML(is);
                Iterator it = propertySheet.getPropertyEditors();
                while (it.hasNext()) {
                    AbstractPropertyEditor p;
                    String cp;
                    PropertyEditor editor = (PropertyEditor)it.next();
                    if (!(editor instanceof AbstractPropertyEditor) || (cp = (p = (AbstractPropertyEditor)editor).getCentreProperty()) == null) continue;
                    if (tool == null) {
                        tool = new FilterTool();
                    }
                    tool.addProperty(filter, p);
                }
                if (tool != null) {
                    this.oldTool = application.getTool();
                    application.setTool(tool);
                } else {
                    this.oldTool = null;
                }
                c = pfc;
            }
            if (c == null) {
                c = (Component)Beans.instantiate(filter.getClass().getClassLoader(), filter.getClass().getName() + "Customizer");
            }
            if (c != null) {
                if (c instanceof FilterCustomizer) {
                    ((FilterCustomizer)c).setFilterContext(application);
                }
                if (c instanceof PreviewFilterCustomizer) {
                    pfc = (PreviewFilterCustomizer)c;
                    Layer layer = this.getActiveLayer();
                    BufferedImage selection = this.composition.getSelection();
                    BufferedImage sourceImage = layer.getImage();
                    Rectangle bounds = this.composition.getSelectedBounds();
                    boolean wholeImage = false;
                    if (bounds != null) {
                        if (this.composition.hasFloatingSelection()) {
                            bounds.setLocation(0, 0);
                        }
                    } else {
                        bounds = new Rectangle(0, 0, sourceImage.getWidth(), sourceImage.getHeight());
                        wholeImage = true;
                    }
                    if (usePreview) {
                        if (!pfc.previewWholeImage()) {
                            Dimension size = pfc.getPreviewSize();
                            bounds.width = Math.min(bounds.width, size.width);
                            bounds.height = Math.min(bounds.height, size.height);
                        }
                        BufferedImage preview = this.composition.hasFloatingSelection() ? this.composition.getFloatingLayer().getImage() : ImageUtils.getSubimage(sourceImage, bounds.x, bounds.y, bounds.width, bounds.height);
                        pfc.setPreviewImage(preview);
                    } else {
                        final FilterTool t = tool;
                        pfc.addPropertyChangeListener(new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent e) {
                                if (t != null) {
                                    t.update();
                                }
                                CompositionDocument.this.composition.startUpdate();
                                CompositionDocument.this.composition.updateAll();
                                CompositionDocument.this.composition.endUpdate();
                            }
                        });
                        this.composition.setPreviewFilter(layer, (BufferedImageOp)filter, 0.0f, 0.0f);
                        if (pfc.previewWholeImage()) {
                            pfc.setPreviewImage(this.composition.getActiveImage());
                        }
                    }
                }
                ((Customizer)((Object)c)).setObject(filter);
                FilterCustomizerDialog d = new FilterCustomizerDialog(filter.toString(), (Customizer)((Object)c), filter);
                d.showDialog();
                this.getApplication().busyCursor(false);
                return;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            System.out.println("Exception in Customizer: " + e);
            e.printStackTrace();
        }
        application.setLastFilter(filter);
        this.filterImageNoCustomizer(filter);
        this.setFiltering(false);
    }

    public void filterImageNoCustomizer(Object filter) {
        this.getApplication().busyCursor(true);
        this.doTask(new FilterTask(filter));
        this.setFiltering(false);
        this.getApplication().busyCursor(false);
    }

    public Object getLastFilter() {
        return ((CompositionApplication)this.getApplication()).getLastFilter();
    }

    public void repeatLastFilter() {
        this.filterImageNoCustomizer(this.getLastFilter());
    }

    public void showLastFilter() {
        this.filterImage(this.getLastFilter());
    }

    class FilterTask
    extends ImageTask {
        private Object filter;
        private Rectangle bounds;
        private Rectangle repaintBounds;

        public FilterTask(Object filter) {
            super(CompositionDocument.this.getComposition());
            this.filter = filter;
        }

        public void doTask() {
            BufferedImage newImage;
            BufferedImage sourceImage = null;
            boolean wholeImage = false;
            boolean floatBeforeFiltering = false;
            super.doTask();
            this.composition.simplifyActiveLayer();
            floatBeforeFiltering = this.filter instanceof FlipFilter;
            this.composition.startUpdate();
            if (!floatBeforeFiltering) {
                this.composition.dropFloatingSelection();
            }
            Layer activeLayer = this.composition.getActiveLayer();
            Layer floatingLayer = this.composition.getFloatingLayer();
            Layer sourceLayer = null;
            BufferedImage selection = this.composition.getSelection();
            if (floatingLayer != null) {
                sourceLayer = floatingLayer;
                this.bounds = floatingLayer.getBounds();
                this.bounds.y = 0;
                this.bounds.x = 0;
                sourceImage = sourceLayer.getImage();
            } else {
                sourceLayer = activeLayer;
                sourceImage = sourceLayer.getImage();
                this.bounds = this.composition.getSelectedBounds();
                if (this.bounds == null) {
                    this.bounds = activeLayer.getBounds();
                    wholeImage = true;
                }
                if (floatBeforeFiltering) {
                    this.saveArea(this.bounds, sourceImage);
                    this.composition.floatSelection();
                    sourceLayer = floatingLayer = this.composition.getFloatingLayer();
                    this.bounds = floatingLayer.getBounds();
                    this.bounds.y = 0;
                    this.bounds.x = 0;
                    sourceImage = sourceLayer.getImage();
                }
            }
            BufferedImage imageToFilter = wholeImage ? sourceImage : ImageUtils.getSubimage(sourceImage, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            if (this.filter instanceof BufferedImageOp) {
                newImage = ((BufferedImageOp)this.filter).filter(imageToFilter, null);
            } else if (this.filter instanceof RasterOp) {
                newImage = new BufferedImage(imageToFilter.getWidth(), imageToFilter.getHeight(), imageToFilter.getType());
                ((RasterOp)this.filter).filter(imageToFilter.getRaster(), newImage.getRaster());
            } else {
                FilteredImageSource producer = new FilteredImageSource(imageToFilter.getSource(), (ImageFilter)this.filter);
                newImage = ImageUtils.createImage(producer);
            }
            Rectangle newBounds = new Rectangle(newImage.getWidth(), newImage.getHeight());
            if (floatingLayer != null) {
                this.composition.update(this.composition.getFloatingLayer());
                this.composition.addFloatingLayer(newImage, floatingLayer.getX(), floatingLayer.getY());
                AffineTransform at = floatingLayer.getTransform();
                this.composition.getFloatingLayer().setTransform(AffineTransform.getTranslateInstance(at.getTranslateX() + (double)((this.bounds.width - newBounds.width) / 2), at.getTranslateY() + (double)((this.bounds.height - newBounds.height) / 2)));
                this.composition.update(this.composition.getFloatingLayer());
            } else {
                this.saveArea(this.bounds, sourceImage);
                if (wholeImage) {
                    Graphics2D g = sourceImage.createGraphics();
                    g.setComposite(AlphaComposite.getInstance(2));
                    g.drawImage(newImage, null, 0, 0);
                    g.dispose();
                } else {
                    WritableRaster dstRaster = sourceImage.getSubimage(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height).getRaster();
                    WritableRaster selRaster = selection.getSubimage(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height).getRaster();
                    ImageUtils.composeThroughMask(newImage.getRaster(), dstRaster, selRaster);
                }
                this.repaintBounds = this.bounds.union(sourceLayer.getBounds());
                this.composition.update(this.repaintBounds);
            }
            this.composition.endUpdate();
        }

        public String getPresentationName() {
            return "Filter";
        }
    }

    public class FilterCustomizerDialog
    implements ActionListener {
        private Customizer customizer;
        private Object filter;
        private JButton okButton;
        private JButton cancelButton;
        private boolean ok = false;
        private JInternalFrame iFrame;
        private JDialog dialog;
        private JMenuItem loadItem;
        private JMenuItem saveItem;

        public FilterCustomizerDialog(String title, Customizer customizer, Object filter) {
            JRootPane rootPane;
            Container contentPane;
            Application application = Application.getInstance();
            if (application.isMDI) {
                this.iFrame = new JInternalFrame(title, true);
                contentPane = this.iFrame.getContentPane();
                rootPane = this.iFrame.getRootPane();
            } else {
                this.dialog = new JDialog((Frame)application.getFrame(), title);
                contentPane = this.dialog.getContentPane();
                rootPane = this.dialog.getRootPane();
            }
            rootPane.setFont(application.getSmallSystemFont());
            this.customizer = customizer;
            this.filter = filter;
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)((Object)customizer), "Center");
            JPanel panel = new JPanel();
            contentPane.add((Component)panel, "South");
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            JPanel panel2 = new JPanel();
            panel2.setLayout(new GridLayout(1, 0, 10, 10));
            panel2.add(this.cancelButton);
            panel2.add(this.okButton);
            panel.add(panel2);
            rootPane.setDefaultButton(this.okButton);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            boolean hasPresets = true;
            if (hasPresets) {
                JMenuBar menuBar = new JMenuBar();
                JMenu fileMenu = new JMenu("Presets");
                menuBar.add(fileMenu);
                this.loadItem = new JMenuItem("Load...");
                fileMenu.add(this.loadItem);
                this.saveItem = new JMenuItem("Save...");
                fileMenu.add(this.saveItem);
                this.loadItem.addActionListener(this);
                this.saveItem.addActionListener(this);
                contentPane.add((Component)menuBar, "North");
            }
            if (application.isMDI) {
                this.iFrame.pack();
                this.iFrame.setLocation(100, 16);
            } else {
                this.dialog.pack();
            }
        }

        public boolean showDialog() {
            Application application = CompositionDocument.this.getApplication();
            if (this.dialog != null) {
                application.setModal(true);
                Dimension size = this.dialog.getPreferredSize();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize().getSize();
                int h = Math.min(size.height, screenSize.height - 30);
                this.dialog.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 3);
                this.dialog.setSize(size.width, h);
                this.dialog.setVisible(true);
            } else {
                application.addInternalFrame(this.iFrame, JDesktopPane.MODAL_LAYER);
                Dimension size = this.iFrame.getPreferredSize();
                this.iFrame.setMinimumSize(new Dimension(size.width, 200));
                Dimension maxSize = application.getDesktopPane().getSize();
                int h = Math.min(size.height, maxSize.height - 30);
                this.iFrame.setMaximumSize(new Dimension(size.width, h));
                this.iFrame.setSize(size.width, h);
                application.setModal(true);
                this.iFrame.setVisible(true);
                this.iFrame.moveToFront();
            }
            CompositionDocument.this.filtering = true;
            CompositionDocument.this.getController().enableCommands();
            return this.ok;
        }

        private void closeDialog() {
            CompositionApplication application = (CompositionApplication)CompositionDocument.this.getApplication();
            CompositionDocument.this.filtering = false;
            if (CompositionDocument.this.oldTool != null) {
                application.setTool(CompositionDocument.this.oldTool);
            }
            if (this.dialog != null) {
                this.dialog.dispose();
                this.dialog = null;
            } else {
                try {
                    application.setModal(false);
                    this.iFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.iFrame = null;
            }
            CompositionDocument.this.getController().enableCommands();
        }

        public void actionPerformed(ActionEvent event) {
            block16: {
                CompositionApplication application = (CompositionApplication)CompositionDocument.this.getApplication();
                Object source = event.getSource();
                if (source == this.cancelButton) {
                    CompositionDocument.this.composition.setPreviewFilter(null, null, 0.0f, 0.0f);
                    CompositionDocument.this.composition.startUpdate();
                    CompositionDocument.this.composition.updateAll();
                    CompositionDocument.this.composition.endUpdate();
                    this.closeDialog();
                } else if (source == this.okButton) {
                    CompositionDocument.this.composition.setPreviewFilter(null, null, 0.0f, 0.0f);
                    this.ok = true;
                    this.closeDialog();
                    application.setLastFilter(this.filter);
                    CompositionDocument.this.filterImageNoCustomizer(this.filter);
                } else if (source == this.loadItem) {
                    FileDialog d = new FileDialog((Frame)application.getFrame(), "Load Preset", 0);
                    d.setVisible(true);
                    String directory = d.getDirectory();
                    String file = d.getFile();
                    if (directory != null && file != null) {
                        try {
                            BufferedInputStream os = new BufferedInputStream(new FileInputStream(new File(directory, file)));
                            XMLDecoder decoder = new XMLDecoder(os);
                            Object o = decoder.readObject();
                            decoder.close();
                            if (o != null && o.getClass() == this.filter.getClass()) {
                                this.filter = o;
                                this.customizer.setObject(this.filter);
                                CompositionDocument.this.composition.setPreviewFilter(CompositionDocument.this.composition.getActiveLayer(), (BufferedImageOp)this.filter, 0.0f, 0.0f);
                                CompositionDocument.this.composition.startUpdate();
                                CompositionDocument.this.composition.updateAll();
                                CompositionDocument.this.composition.endUpdate();
                                break block16;
                            }
                            JOptionPane.showMessageDialog(application.getDialogParent(), "The file you chose is not a preset of this filter.", "Error", 0);
                        }
                        catch (Exception e) {
                            CompositionApplication.reportException("Can't load preset", "Error", e);
                        }
                    }
                } else if (source == this.saveItem) {
                    int index;
                    String name = this.filter.toString();
                    if (name.endsWith("...")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    if ((index = name.lastIndexOf(47)) != -1) {
                        name = name.substring(index + 1);
                    }
                    name = name + ".xml";
                    FileDialog d = new FileDialog((Frame)application.getFrame(), "Save Preset", 1);
                    d.setFile(name);
                    d.setVisible(true);
                    String directory = d.getDirectory();
                    String file = d.getFile();
                    if (directory != null && file != null) {
                        try {
                            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(directory, file)));
                            XMLEncoder encoder = new XMLEncoder(os);
                            encoder.writeObject(this.filter);
                            encoder.close();
                        }
                        catch (Exception e) {
                            CompositionApplication.reportException("Can't save preset", "Error", e);
                        }
                    }
                }
            }
        }
    }

    class CropTask
    extends Task {
        private int width;
        private int height;
        private int originalWidth;
        private int originalHeight;
        private Vector mementos;

        public CropTask() {
            Composition composition = CompositionDocument.this.getComposition();
            this.originalWidth = composition.getWidth();
            this.originalHeight = composition.getHeight();
        }

        public void doTask() {
            Rectangle bounds = CompositionDocument.this.composition.getSelectedBounds();
            if (bounds != null) {
                Composition composition = CompositionDocument.this.getComposition();
                if (composition.hasFloatingSelection()) {
                    bounds.setLocation(0, 0);
                }
                this.width = bounds.width;
                this.height = bounds.height;
                this.mementos = new Vector();
                Iterator it = composition.getLayers().iterator();
                while (it.hasNext()) {
                    Memento m = ((Layer)it.next()).getLayerContentsMemento();
                    if (m == null) continue;
                    this.mementos.add(m);
                }
                composition.startUpdate();
                composition.dropFloatingSelection();
                composition.crop(bounds);
                composition.endUpdate();
            }
        }

        public void undo() {
            Iterator it = this.mementos.iterator();
            while (it.hasNext()) {
                ((Memento)it.next()).restore();
            }
            int t = this.originalWidth;
            this.originalWidth = this.width;
            this.width = t;
            t = this.originalHeight;
            this.originalHeight = this.height;
            this.height = t;
            CompositionDocument.this.composition.sizeChanged(this.width, this.height);
        }

        public void redo() {
            this.undo();
        }

        public String getPresentationName() {
            return "Crop";
        }
    }

    class ResizeTask
    extends Task {
        private int width;
        private int height;
        private int originalWidth;
        private int originalHeight;
        private BufferedImageOp scaleFilter;
        private Vector mementos;

        public ResizeTask(int width, int height, BufferedImageOp scaleFilter) {
            Composition composition = CompositionDocument.this.getComposition();
            this.width = width;
            this.height = height;
            this.scaleFilter = scaleFilter;
            this.originalWidth = composition.getWidth();
            this.originalHeight = composition.getHeight();
        }

        public void doTask() {
            Composition composition = CompositionDocument.this.getComposition();
            this.mementos = new Vector();
            Iterator it = composition.getLayers().iterator();
            while (it.hasNext()) {
                Memento m = ((Layer)it.next()).getLayerContentsMemento();
                if (m == null) continue;
                this.mementos.add(m);
            }
            composition.resize(this.width, this.height, this.scaleFilter);
        }

        public void undo() {
            Iterator it = this.mementos.iterator();
            while (it.hasNext()) {
                ((Memento)it.next()).restore();
            }
            int t = this.originalWidth;
            this.originalWidth = this.width;
            this.width = t;
            t = this.originalHeight;
            this.originalHeight = this.height;
            this.height = t;
            CompositionDocument.this.composition.sizeChanged(this.width, this.height);
        }

        public void redo() {
            this.undo();
        }

        public String getPresentationName() {
            return "Resize";
        }
    }
}

