/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Task;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.layer.Layer;

public class MoveSelectionTask
extends Task {
    private CompositionDocument document;
    private int dx;
    private int dy;
    private boolean wasFloating;

    public MoveSelectionTask(CompositionDocument document, int dx, int dy, boolean copy) {
        Composition composition = document.getComposition();
        this.document = document;
        this.dx = dx;
        this.dy = dy;
        this.wasFloating = composition.hasFloatingSelection();
        if (!this.wasFloating) {
            composition.floatSelection(copy);
        }
    }

    private void moveSelection(int dx, int dy) {
        Composition composition = this.document.getComposition();
        Layer layer = composition.getFloatingLayer();
        Layer selection = composition.getSelectionLayer();
        if (layer != null) {
            composition.startUpdate();
            composition.update(layer);
            layer.setX(layer.getX() + dx);
            layer.setY(layer.getY() + dy);
            selection.setX(selection.getX() + dx);
            selection.setY(selection.getY() + dy);
            composition.update(layer);
            composition.endUpdate();
        }
    }

    public void doTask() {
        this.moveSelection(this.dx, this.dy);
    }

    public void undo() {
        Composition composition = this.document.getComposition();
        this.moveSelection(-this.dx, -this.dy);
        if (!this.wasFloating) {
            composition.dropFloatingSelection();
        }
    }

    public void redo() {
        Composition composition = this.document.getComposition();
        if (!this.wasFloating) {
            composition.floatSelection();
        }
        this.moveSelection(this.dx, this.dy);
    }

    public String getPresentationName() {
        return "Move";
    }
}

