/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Application;
import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.Palette;
import com.jhlabs.ie.Tool;
import com.jhlabs.ie.tool.ArrowTool;
import com.jhlabs.ie.tool.DropperTool;
import com.jhlabs.ie.tool.SelectAreaTool;
import com.jhlabs.ie.ui.ColorPatches;
import com.jhlabs.ie.ui.StrokePreview;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class Toolbox
extends JPanel
implements Palette,
ActionListener,
PropertyChangeListener {
    private CompositionApplication application;
    private JPanel toolButtons;
    private ButtonGroup toolGroup;
    private Hashtable tools;
    public ColorPatches colorPatches;
    private StrokePreview strokePreview;
    protected Insets noInsets = new Insets(0, 0, 0, 0);
    public Tool dropperTool;
    public Tool arrowTool;

    public Toolbox() {
        this.application = (CompositionApplication)CompositionApplication.getInstance();
        this.toolGroup = new ButtonGroup();
        this.setLayout(new SuperGridLayout(3, 1));
        this.toolButtons = new JPanel();
        this.toolButtons.setLayout(new GridLayout(0, 2));
        this.tools = new Hashtable();
        Vector v = this.application.getPluginTools();
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                Tool t = (Tool)v.elementAt(i);
                this.makeToolBoxButton(t, t.getClass().getName());
                if (t instanceof DropperTool) {
                    this.dropperTool = t;
                    continue;
                }
                if (!(t instanceof ArrowTool)) continue;
                this.arrowTool = t;
            }
        }
        this.add(this.toolButtons);
        this.add(Box.createVerticalStrut(8));
        this.colorPatches = new ColorPatches(this.application.getPaintingContext());
        JPanel p = new JPanel();
        this.add(p);
        p.add(this.colorPatches);
        this.application.addPropertyChangeListener(this);
    }

    public void startup(Application application) {
    }

    public void shutdown() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        JToggleButton b;
        Tool tool;
        String name = event.getPropertyName();
        if ("tool".equals(name) && (tool = this.application.getTool()) != null && (b = (JToggleButton)this.tools.get(tool)) != null) {
            b.setSelected(true);
        }
    }

    protected void makeToolBoxButton(Tool tool, String name) {
        JToggleButton b;
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        try {
            URL url = tool.getClass().getResource(name + ".gif");
            if (url == null) {
                url = tool.getClass().getResource(name + ".png");
            }
            ImageIcon icon = new ImageIcon(url);
            b = new JToggleButton(icon);
        }
        catch (Exception e) {
            b = new JToggleButton(name);
        }
        if (this.application.getTool() == null && tool instanceof SelectAreaTool) {
            b.setSelected(true);
            this.application.setTool(tool);
        }
        b.setHorizontalAlignment(0);
        b.setBorderPainted(true);
        b.setFocusPainted(false);
        Toolbox toolbox = this;
        if (toolbox.application.isMacintosh()) {
            b.putClientProperty("Quaqua.Button.style", "square");
        } else {
            b.setMargin(this.noInsets);
        }
        b.setToolTipText(tool.getToolTipText());
        b.addActionListener(this);
        b.setSize(24, 24);
        this.toolButtons.add(b);
        this.toolGroup.add(b);
        this.tools.put(b, tool);
        this.tools.put(tool, b);
        new ToolDoubleClickAdapter(b);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Tool tool = (Tool)this.tools.get(source);
        if (tool != null) {
            this.application.setTool(tool);
        }
    }

    public String getName() {
        return "showTools";
    }

    class ToolDoubleClickAdapter
    extends MouseAdapter {
        private Component component;
        private int lastX;
        private int lastY;

        public ToolDoubleClickAdapter(Component component) {
            this.component = component;
            component.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (e.getClickCount() == 2 && x == this.lastX && y == this.lastY) {
                Tool tool = Toolbox.this.application.getTool();
                Toolbox.this.application.showToolCustomizer(tool);
            }
            this.lastX = x;
            this.lastY = y;
        }
    }

    class ToolIcon
    extends ImageIcon {
        public ToolIcon(URL url) {
            super(url);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            g.setColor(Color.gray);
            int w = x + this.getIconWidth() - 1;
            for (int i = 0; i <= 4; ++i) {
                g.drawLine(w - 4 + i, y + i, w, y + i);
            }
        }
    }
}

