/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.io;

import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.FileFormat;
import com.jhlabs.image.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class FileFormatBMP
extends FileFormat {
    public FileFormatBMP() {
        super("BMP", "image/bmp", ".bmp", null);
    }

    public boolean canRead(byte[] fileStart) {
        return fileStart[0] == 66 && fileStart[1] == 77;
    }

    public boolean shouldOpenFile() {
        return false;
    }

    public BufferedImage readBufferedImage(File file, InputStream in) throws IOException {
        return ImageIO.read(file);
    }

    public void writeImage(File file, OutputStream out, CompositionDocument document) throws IOException {
        BufferedImage image = document.getCompositeImage();
        int w = image.getWidth();
        int h = image.getHeight();
        DataOutputStream dos = new DataOutputStream(out);
        int offset = 54;
        int imageSize = 4 * w * h;
        int size = offset + imageSize;
        dos.writeByte(66);
        dos.writeByte(77);
        this.writeLEInt(dos, size);
        this.writeLEInt(dos, 0);
        this.writeLEInt(dos, offset);
        this.writeLEInt(dos, 40);
        this.writeLEInt(dos, w);
        this.writeLEInt(dos, h);
        dos.writeByte(1);
        dos.writeByte(0);
        dos.writeByte(32);
        dos.writeByte(0);
        this.writeLEInt(dos, 0);
        this.writeLEInt(dos, imageSize);
        this.writeLEInt(dos, 2835);
        this.writeLEInt(dos, 2835);
        this.writeLEInt(dos, 0);
        this.writeLEInt(dos, 0);
        int[] pixels = null;
        for (int y = 0; y < h; ++y) {
            pixels = ImageUtils.getRGB(image, 0, h - y - 1, w, 1, pixels);
            for (int x = 0; x < w; ++x) {
                this.writeLEInt(dos, pixels[x]);
            }
        }
        dos.close();
    }

    private void writeLEInt(DataOutputStream dos, int n) throws IOException {
        dos.writeByte(n);
        dos.writeByte(n >> 8);
        dos.writeByte(n >> 16);
        dos.writeByte(n >> 24);
    }
}

