/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.io;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.FileFormat;
import com.jhlabs.ie.layer.ImageLayer;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.xml.XMLParser;
import com.jhlabs.xml.XMLUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileFormatIE
extends FileFormat {
    public FileFormatIE() {
        super("Native", new String[0], new String[]{".ie"}, new String[]{"IE"});
    }

    public boolean canRead(byte[] fileStart) {
        return fileStart[0] == 80 && fileStart[1] == 75;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean readImage(File file, InputStream in, CompositionDocument document) throws IOException {
        Composition newComposition = null;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(in));
        ZipEntry entry = zis.getNextEntry();
        Hashtable<String, BufferedImage> index = new Hashtable<String, BufferedImage>();
        byte[] buf = new byte[1024];
        while (entry != null) {
            String entryName = entry.getName();
            if (entry.getName().equals("index.xml")) {
                IEDocumentHandler handler = new IEDocumentHandler(index);
                try {
                    XMLParser xp = new XMLParser(false);
                    xp.setDocumentHandler(handler);
                    xp.parse(new InputSource(zis));
                    newComposition = handler.getComposition();
                }
                catch (SAXException e) {
                    throw new IOException("Can't read image: " + e.getMessage());
                }
            } else {
                BufferedImage image = ImageUtils.cloneImage(ImageIO.read(zis));
                index.put(entryName, image);
            }
            zis.closeEntry();
            entry = zis.getNextEntry();
        }
        zis.close();
        Composition oldComposition = document.getComposition();
        if (newComposition != null) {
            newComposition.setCompositionListeners(oldComposition.getCompositionListeners());
        }
        document.setComposition(newComposition);
        return true;
    }

    public void writeImage(File file, OutputStream out, CompositionDocument document) throws IOException {
        CRC32 crc323;
        byte[] data;
        ZipEntry entry;
        Composition composition = document.getComposition();
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(out));
        long time = new Date().getTime();
        zos.setMethod(8);
        zos.setMethod(0);
        int i = 0;
        Enumeration e = composition.getLayerEnumeration();
        while (e.hasMoreElements()) {
            Layer layer = (Layer)e.nextElement();
            entry = new ZipEntry("layer" + ++i + ".png");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)layer.getImage(), "png", bos);
            data = bos.toByteArray();
            entry.setSize(data.length);
            crc323 = new CRC32();
            crc323.update(data);
            entry.setCrc(crc323.getValue());
            entry.setTime(time);
            zos.putNextEntry(entry);
            zos.write(data);
            zos.closeEntry();
        }
        entry = new ZipEntry("index.xml");
        entry.setTime(time);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        ps.println("<composition version='1.0' width='" + composition.getWidth() + "' height='" + composition.getHeight() + "'>");
        i = 0;
        e = composition.getLayerEnumeration();
        while (e.hasMoreElements()) {
            Layer layer = (Layer)e.nextElement();
            ps.println(" <layer id='" + "layer" + ++i + ".png" + "' name='" + XMLUtils.xmlEscape(layer.getName()) + "' locked='" + layer.isLocked() + "' visible='" + layer.isVisible() + "' mode='" + layer.getOperation() + "' opacity='" + (float)layer.getOpacity() / 255.0f + "'>");
            ps.println(" </layer>");
        }
        ps.println("</composition>");
        ps.close();
        data = bos.toByteArray();
        entry.setSize(data.length);
        crc323 = new CRC32();
        crc323.update(data);
        entry.setCrc(crc323.getValue());
        entry.setTime(time);
        zos.putNextEntry(entry);
        zos.write(data);
        zos.closeEntry();
        zos.close();
    }

    public class IEDocumentHandler
    extends HandlerBase {
        private Hashtable index;
        private Composition composition;

        public IEDocumentHandler(Hashtable index) {
            this.index = index;
        }

        public void startElement(String tag, AttributeList attrs) throws SAXException {
            if (tag.equals("composition")) {
                int width = Integer.parseInt(attrs.getValue("width"));
                int height = Integer.parseInt(attrs.getValue("height"));
                this.composition = new Composition(width, height);
            } else if (tag.equals("layer")) {
                String id = attrs.getValue("id");
                String name = attrs.getValue("name");
                int mode = Integer.parseInt(attrs.getValue("mode"));
                int opacity = (int)(255.0f * Float.parseFloat(attrs.getValue("opacity")));
                boolean locked = Boolean.valueOf(attrs.getValue("locked"));
                boolean visible = Boolean.valueOf(attrs.getValue("visible"));
                BufferedImage image = (BufferedImage)this.index.get(id);
                ImageLayer layer = new ImageLayer(name, image);
                layer.setLocked(locked);
                layer.setVisible(visible);
                layer.setOperation(mode);
                layer.setOpacity(opacity);
                this.composition.addLayer(layer);
            }
        }

        public void endElement(String tag) throws SAXException {
        }

        public Composition getComposition() {
            return this.composition;
        }
    }
}

