/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.GrabHandle;
import com.jhlabs.ie.ImageTask;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.ImageUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.NumberFormat;

public class ArrowTool
extends ImageTool {
    private AffineTransform originalTransform;
    private static int TRANSLATE = 1;
    private static int ROTATE = 2;
    private static int SHEAR = 3;
    private static int REFLECT = 4;
    private static int SCALE = 5;
    private static int SHEAR_X = 6;
    private static int SHEAR_Y = 7;
    private int mode = TRANSLATE;
    private int handle;
    private Point2D.Double center;
    private double startAngle;
    private NumberFormat format = NumberFormat.getInstance();
    private TransformTask task;
    private AffineTransform startTransform;

    public ArrowTool() {
        this.format.setMinimumFractionDigits(2);
    }

    public boolean usesFloatingSelection() {
        return true;
    }

    public boolean isPaintingTool() {
        return false;
    }

    public boolean doStartDrag() {
        Composition composition = this.getComposition();
        Layer layer = composition.getFloatingLayer();
        if (layer == null) {
            boolean copy = this.event.isAltDown();
            CompositionDocument document = this.view.getDocument();
            this.task = new TransformTask(composition);
            document.setPendingTask(this.task);
            if (!copy) {
                Rectangle r = composition.getSelectedBounds();
                if (r == null) {
                    r = composition.getActiveLayer().getBounds();
                }
                this.task.touchRectangle(r);
            }
            composition.floatSelection(copy);
            layer = composition.getFloatingLayer();
            this.startTransform = new AffineTransform(layer.getTransform());
        }
        if (layer != null) {
            AffineTransform viewTransform = this.view.getViewTransform();
            this.originalTransform = layer.getTransform();
            if (this.originalTransform == null) {
                this.originalTransform = new AffineTransform();
            }
            this.handle = GrabHandle.findHandle(this.startX, this.startY, layer.getBounds(), this.originalTransform, viewTransform, 8);
            this.mode = this.handle == 15 || this.event.isMetaDown() ? TRANSLATE : (this.handle == 0 ? ROTATE : (this.handle == 65 || this.handle == 66 ? SHEAR_Y : (this.handle == 68 || this.handle == 72 ? SHEAR_X : SCALE)));
            Rectangle r = layer.getBounds();
            this.center = new Point2D.Double(r.getCenterX(), (int)r.getCenterY());
            this.originalTransform.transform(this.center, this.center);
            Point2D.Double sxy = new Point2D.Double(this.startX, this.startY);
            try {
                viewTransform.inverseTransform(sxy, sxy);
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            this.startAngle = Math.atan2(sxy.y - this.center.y, sxy.x - this.center.x);
        }
        return true;
    }

    public void doDrag(boolean erase) {
        AffineTransform transform;
        Composition composition = this.getComposition();
        Layer layer = composition.getFloatingLayer();
        if (layer == null) {
            return;
        }
        AffineTransform t = layer.getTransform();
        Point2D.Double cxy = new Point2D.Double(this.currX, this.currY);
        Point2D.Double sxy = new Point2D.Double(this.startX, this.startY);
        try {
            AffineTransform viewTransform = this.view.getViewTransform();
            viewTransform.inverseTransform(cxy, cxy);
            viewTransform.inverseTransform(sxy, sxy);
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        if (this.mode == SCALE) {
            try {
                this.originalTransform.inverseTransform(cxy, cxy);
                this.originalTransform.inverseTransform(sxy, sxy);
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            Rectangle r = layer.getBounds();
            Rectangle2D.Double nr = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
            GrabHandle.moveHandle(this.handle, cxy.getX() - sxy.getX(), cxy.getY() - sxy.getY(), nr);
            Point2D start = GrabHandle.getHandle(GrabHandle.oppositeHandle(this.handle), nr);
            double sx = ((RectangularShape)nr).getWidth() / (double)r.width;
            double sy = ((RectangularShape)nr).getHeight() / (double)r.height;
            if (this.event.isShiftDown()) {
                sx = sy = Math.max(sx, sy);
            }
            transform = new AffineTransform();
            transform.translate(start.getX(), start.getY());
            transform.scale(sx, sy);
            transform.translate(-start.getX(), -start.getY());
        } else if (this.mode == ROTATE) {
            transform = this.getRotation(this.center, cxy);
        } else if (this.mode == SHEAR || this.mode == SHEAR_X || this.mode == SHEAR_Y) {
            Point2D.Double c = new Point2D.Double();
            try {
                this.originalTransform.inverseTransform(cxy, cxy);
                this.originalTransform.inverseTransform(sxy, sxy);
                this.originalTransform.inverseTransform(this.center, c);
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            transform = this.getShear(c, sxy, cxy, this.mode, this.handle == 66 || this.handle == 68);
        } else {
            transform = this.mode == REFLECT ? this.getReflection(this.center, cxy) : this.getTranslation(sxy, cxy);
        }
        if (this.mode == SCALE || this.mode == SHEAR_X || this.mode == SHEAR_Y) {
            transform.preConcatenate(this.originalTransform);
        } else {
            transform.concatenate(this.originalTransform);
        }
        layer.setTransform(transform);
        Rectangle2D r1 = this.getAffectedBounds(t);
        Rectangle2D r2 = this.getAffectedBounds(transform);
        Rectangle2D.union(r1, r2, r1);
        Rectangle r = new Rectangle();
        r.setRect(r1);
        composition.startUpdate();
        composition.update(r);
        composition.endUpdate();
        this.view.repaint();
    }

    public void doEndDrag() {
        this.originalTransform = null;
        this.task = null;
    }

    private Rectangle2D getAffectedBounds(AffineTransform t) {
        Composition composition = this.getComposition();
        if (composition.hasFloatingSelection()) {
            Layer layer = composition.getFloatingLayer();
            Rectangle r = layer.getBounds();
            return t.createTransformedShape(r).getBounds();
        }
        return null;
    }

    public void paint(Graphics2D g) {
        Composition composition = this.getComposition();
        if (composition.hasFloatingSelection()) {
            Layer layer = composition.getFloatingLayer();
            Rectangle r = layer.getBounds();
            g.setColor(Color.red);
            AffineTransform t = layer.getTransform();
            if (t != null) {
                GrabHandle.drawHandles(g, r, t, this.view.getViewTransform(), 8);
            } else {
                GrabHandle.drawHandles(g, r, new AffineTransform(), this.view.getViewTransform(), 8);
            }
        } else {
            Layer layer;
            Rectangle r = composition.getSelectedBounds();
            if (r == null && (layer = composition.getActiveLayer()) != null) {
                r = ImageUtils.getSelectedBounds(layer.getImage());
            }
            if (r != null) {
                g.setColor(Color.orange);
                GrabHandle.drawHandles(g, r, new AffineTransform(), this.view.getViewTransform(), 8);
            }
        }
    }

    protected AffineTransform getTranslation(Point2D.Double start, Point2D.Double end) {
        double tx = start.x - end.x;
        double ty = start.y - end.y;
        if (this.event.isShiftDown()) {
            if (Math.abs(tx) > Math.abs(ty)) {
                ty = 0.0;
            } else {
                tx = 0.0;
            }
        }
        this.view.showMessage("Distance: x=" + tx + ", y=" + ty);
        AffineTransform t = new AffineTransform();
        t.setToTranslation(-tx, -ty);
        return t;
    }

    protected AffineTransform getRotation(Point2D.Double start, Point2D.Double end) {
        double tx = end.x - start.x;
        double ty = end.y - start.y;
        double angle = Math.atan2(ty, tx);
        angle -= this.startAngle;
        if (this.event.isShiftDown()) {
            angle = 24.0 * angle / (Math.PI * 2);
            angle = Math.round(angle);
            angle = Math.PI * 2 * angle / 24.0;
        }
        this.view.showMessage("Angle: " + this.format.format(Math.toDegrees(-angle)));
        return AffineTransform.getRotateInstance(angle, start.x, start.y);
    }

    protected AffineTransform getShear(Point2D.Double center, Point2D.Double start, Point2D.Double end, int mode, boolean invert) {
        double sx = (end.x - start.x) / 64.0;
        double sy = -(end.y - start.y) / 64.0;
        if (this.event.isShiftDown()) {
            if (Math.abs(sx) > Math.abs(sy)) {
                sx = 0.0;
            } else {
                sy = 0.0;
            }
        }
        if (mode == SHEAR_X) {
            sy = 0.0;
        } else if (mode == SHEAR_Y) {
            sx = 0.0;
        }
        if (invert) {
            sx = -sx;
            sy = -sy;
        }
        this.view.showMessage("Scale: x=" + sx + ", y=" + sy);
        AffineTransform t = new AffineTransform();
        t.translate(center.x, center.y);
        t.concatenate(new AffineTransform(1.0, sy, sx, 1.0, 0.0, 0.0));
        t.translate(-center.x, -center.y);
        return t;
    }

    protected AffineTransform getReflection(Point2D.Double start, Point2D.Double end) {
        double tx = start.x - end.x;
        double ty = start.y - end.y;
        double angle = Math.atan2(-ty, tx);
        if (this.event.isShiftDown()) {
            angle = 8.0 * angle / (Math.PI * 2);
            angle = Math.round(angle);
            angle = Math.PI * 2 * angle / 8.0;
        }
        this.view.showMessage("Angle: " + Math.toDegrees(angle));
        AffineTransform t = new AffineTransform();
        t.translate(start.x, start.y);
        t.scale(-1.0, 1.0);
        t.rotate(angle);
        t.translate(-start.x, -start.y);
        return t;
    }

    public boolean needsMouseMovedEvents() {
        return true;
    }

    public void mouseMoved(MouseEvent e) {
        if (this.view == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        Composition composition = this.getComposition();
        Rectangle bounds = null;
        AffineTransform viewTransform = this.view.getViewTransform();
        AffineTransform originalTransform = null;
        Layer layer = composition.getFloatingLayer();
        if (layer == null) {
            bounds = composition.getSelectedBounds();
            if (bounds == null) {
                return;
            }
        } else {
            originalTransform = layer.getTransform();
            bounds = layer.getBounds();
        }
        if (originalTransform == null) {
            originalTransform = new AffineTransform();
        }
        int handle = GrabHandle.findHandle(x, y, bounds, originalTransform, viewTransform, 8);
        int cid = -1;
        switch (handle) {
            case 15: {
                cid = 13;
                break;
            }
            case 0: {
                cid = 0;
                break;
            }
            case 1: {
                cid = 10;
                break;
            }
            case 2: {
                cid = 11;
                break;
            }
            case 4: {
                cid = 8;
                break;
            }
            case 8: {
                cid = 9;
                break;
            }
            case 5: {
                cid = 6;
                break;
            }
            case 9: {
                cid = 4;
                break;
            }
            case 6: {
                cid = 7;
                break;
            }
            case 10: {
                cid = 5;
                break;
            }
            case 68: 
            case 72: {
                cid = 11;
                break;
            }
            case 65: 
            case 66: {
                cid = 8;
            }
        }
        if (cid != -1) {
            this.view.setCursor(Cursor.getPredefinedCursor(cid));
        }
    }

    public void keyPressed(KeyEvent e) {
        int c = e.getKeyCode();
        int dx = 0;
        int dy = 0;
        Composition composition = this.getComposition();
        Layer layer = composition.getFloatingLayer();
        switch (c) {
            case 27: {
                if (layer == null || this.startTransform == null) break;
                composition.startUpdate();
                layer.setTransform(this.startTransform);
                composition.updateAll();
                composition.endUpdate();
                break;
            }
            case 38: {
                dy = -1;
                break;
            }
            case 40: {
                dy = 1;
                break;
            }
            case 37: {
                dx = -1;
                break;
            }
            case 39: {
                dx = 1;
            }
        }
        if (this.view != null && (dx != 0 || dy != 0)) {
            if (e.isShiftDown()) {
                dx *= 10;
                dy *= 10;
            }
            if (layer == null) {
                CompositionDocument document = this.view.getDocument();
                this.task = new TransformTask(composition);
                document.setPendingTask(this.task);
                boolean copy = false;
                if (!copy) {
                    Rectangle r = composition.getSelectedBounds();
                    if (r == null) {
                        r = composition.getActiveLayer().getBounds();
                    }
                    this.task.touchRectangle(r);
                }
                composition.floatSelection(copy);
                layer = composition.getFloatingLayer();
                this.startTransform = new AffineTransform(layer.getTransform());
            }
            if (layer != null) {
                composition.startUpdate();
                AffineTransform transform = layer.getTransform();
                composition.update(layer);
                transform.translate(dx, dy);
                composition.update(layer);
                composition.endUpdate();
                this.view.repaint();
            }
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
    }

    public char getShortcutKey() {
        return 'v';
    }

    public String getToolTipText() {
        return "Transform Selection Tool";
    }

    public String getHelpText() {
        return "Transform Selection Tool: Alt key copies selection, Shift key constrains, Meta key forces move";
    }

    class TransformTask
    extends ImageTask {
        public TransformTask(Composition composition) {
            super(composition);
        }

        public void doTask() {
            Composition composition = this.getComposition();
            super.doTask();
            composition.simplifyActiveLayer();
            Layer layer = composition.getFloatingLayer();
            if (layer != null) {
                int w = layer.getWidth();
                int h = layer.getHeight();
                AffineTransform transform = layer.getTransform();
                if (transform != null) {
                    float[] s = new float[]{0.0f, 0.0f, w, 0.0f, 0.0f, h, w, h};
                    float[] t = new float[8];
                    transform.transform(s, 0, t, 0, 4);
                    Rectangle r = new Rectangle((int)t[0], (int)t[1], 0, 0);
                    r.add((int)t[2], (int)t[3]);
                    r.add((int)t[4], (int)t[5]);
                    r.add((int)t[6], (int)t[7]);
                    this.touchRectangle(r);
                }
            }
            composition.startUpdate();
            composition.dropFloatingSelection();
            composition.endUpdate();
        }

        public String getPresentationName() {
            return "Move";
        }
    }
}

