/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.awt.ParagraphLayout;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionView;
import com.jhlabs.ie.GrabHandle;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.FieldWarpFilter;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.swing.SliderFactory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FieldWarpTool
extends ImageTool {
    private FieldWarpFilter.Line[] sourceLines;
    private FieldWarpFilter.Line[] destLines;
    private FieldWarpFilter.Line dragLine;
    private int dragHandle = -1;
    private int dragX = -1;
    private int dragY = -1;
    private boolean adding;
    private boolean showSource = true;
    private boolean showDest = true;
    private FieldWarpFilter filter = new FieldWarpFilter();

    public boolean usesFloatingSelection() {
        return true;
    }

    public boolean doStartDrag() {
        int x = this.view.XTox(this.currX);
        int y = this.view.YToy(this.currY);
        if (this.showDest && this.checkHit(this.destLines, x, y)) {
            return true;
        }
        if (this.showSource && this.checkHit(this.sourceLines, x, y)) {
            return true;
        }
        this.adding = true;
        this.dragLine = new FieldWarpFilter.Line(x, y, x, y);
        this.dragHandle = 1;
        return true;
    }

    private boolean checkHit(FieldWarpFilter.Line[] lines, int x, int y) {
        Composition composition = this.getComposition();
        this.adding = false;
        this.dragLine = null;
        for (int i = 0; i < lines.length; ++i) {
            FieldWarpFilter.Line line = lines[i];
            boolean h = GrabHandle.inHandle(x, y, line.x1, line.y1);
            if (!h && !GrabHandle.inHandle(x, y, line.x2, line.y2)) continue;
            this.dragLine = line;
            this.dragHandle = h ? 0 : 1;
            this.dragX = x;
            this.dragY = y;
            return true;
        }
        return false;
    }

    public void doDrag(boolean erase) {
        Composition composition = this.getComposition();
        Layer layer = composition.getFloatingLayer();
        if (!erase && this.dragLine != null) {
            int x = this.view.XTox(this.currX);
            int y = this.view.YToy(this.currY);
            if (this.dragHandle == 0) {
                this.dragLine.x1 = x;
                this.dragLine.y1 = y;
            } else {
                this.dragLine.x2 = x;
                this.dragLine.y2 = y;
            }
        }
        if (this.dragLine != null) {
            int x1 = this.view.xToX(this.dragLine.x1);
            int y1 = this.view.yToY(this.dragLine.y1);
            int x2 = this.view.xToX(this.dragLine.x1);
            int y2 = this.view.yToY(this.dragLine.y1);
            this.graphics.drawLine(x1, y1, x2, y2);
        }
    }

    public void doEndDrag() {
        Composition composition = this.getComposition();
        if (this.adding) {
            this.sourceLines = this.addLine(this.sourceLines, this.dragLine);
            this.destLines = this.addLine(this.destLines, new FieldWarpFilter.Line(this.dragLine.x1, this.dragLine.y1, this.dragLine.x2, this.dragLine.y2));
        }
        this.filter.setInLines(this.sourceLines);
        this.filter.setOutLines(this.destLines);
        composition.setPreviewFilter(composition.getFloatingLayer(), this.filter, 0.0f, 0.0f);
        composition.startUpdate();
        composition.updateAll();
        composition.endUpdate();
        this.view.repaint();
    }

    private FieldWarpFilter.Line[] addLine(FieldWarpFilter.Line[] array, FieldWarpFilter.Line line) {
        FieldWarpFilter.Line[] newArray = new FieldWarpFilter.Line[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = line;
        return newArray;
    }

    public void setView(CompositionView view) {
        super.setView(view);
        Composition composition = this.getComposition();
        if (view != null) {
            if (composition.getFloatingLayer() == null) {
                Rectangle r = composition.getSelectedBounds();
                if (r == null) {
                    r = ImageUtils.getSelectedBounds(composition.getActiveLayer().getImage());
                }
                if (r != null) {
                    this.sourceLines = new FieldWarpFilter.Line[]{new FieldWarpFilter.Line(10, 10, 10, 60), new FieldWarpFilter.Line(54, 10, 54, 60)};
                    this.destLines = new FieldWarpFilter.Line[]{new FieldWarpFilter.Line(21, 10, 20, 60), new FieldWarpFilter.Line(43, 10, 44, 60)};
                    composition.setPreviewFilter(composition.getActiveLayer(), this.filter, 0.0f, 0.0f);
                }
            }
        } else {
            composition.setPreviewFilter(null, null, 0.0f, 0.0f);
        }
    }

    public void paint(Graphics2D g) {
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (this.showSource) {
            g.setColor(Color.red);
            this.paintLines(g, this.sourceLines);
        }
        if (this.showDest) {
            g.setColor(Color.green);
            this.paintLines(g, this.destLines);
        }
        g.setColor(Color.yellow);
        g.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{1.0f, 1.0f}, 0.0f));
        for (int i = 0; i < this.sourceLines.length; ++i) {
            FieldWarpFilter.Line line1 = this.sourceLines[i];
            FieldWarpFilter.Line line2 = this.destLines[i];
            int x1 = this.view.xToX(line1.x1);
            int y1 = this.view.yToY(line1.y1);
            int x2 = this.view.xToX(line2.x1);
            int y2 = this.view.yToY(line2.y1);
            g.drawLine(x1, y1, x2, y2);
            x1 = this.view.xToX(line1.x2);
            y1 = this.view.yToY(line1.y2);
            x2 = this.view.xToX(line2.x2);
            y2 = this.view.yToY(line2.y2);
            g.drawLine(x1, y1, x2, y2);
        }
    }

    private void paintLines(Graphics2D g, FieldWarpFilter.Line[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            FieldWarpFilter.Line line = lines[i];
            int x1 = this.view.xToX(line.x1);
            int y1 = this.view.yToY(line.y1);
            int x2 = this.view.xToX(line.x2);
            int y2 = this.view.yToY(line.y2);
            g.drawLine(x1, y1, x2, y2);
            g.fillOval(x1 - 2, y1 - 2, 4, 4);
            g.fillOval(x2 - 2, y2 - 2, 4, 4);
        }
    }

    public void setActive(boolean active) {
        Composition composition;
        super.setActive(active);
        if (!active && (composition = this.getComposition()) != null) {
            composition.dropFloatingSelection();
        }
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new FieldWarpToolCustomizer();
    }

    public String getToolTipText() {
        return "Field Warp Tool";
    }

    public String getHelpText() {
        return "Field Warp Tool";
    }

    class FieldWarpToolCustomizer
    extends FilterCustomizer
    implements ChangeListener {
        private FieldWarpTool tool;
        private JCheckBox showSourceCheck;
        private JCheckBox showDestCheck;
        private JSlider amountSlider;
        private JSlider powerSlider;
        private JSlider strengthSlider;

        public FieldWarpToolCustomizer() {
            this.setLayout(new ParagraphLayout());
            this.add((Component)new JLabel("Amount:", 4), ParagraphLayout.NEW_PARAGRAPH);
            this.amountSlider = SliderFactory.createPercentageSlider();
            this.add(this.amountSlider);
            this.amountSlider.addChangeListener(this);
            this.add((Component)new JLabel("Power:", 4), ParagraphLayout.NEW_PARAGRAPH);
            this.powerSlider = SliderFactory.createPercentageSlider();
            this.add(this.powerSlider);
            this.powerSlider.addChangeListener(this);
            this.add((Component)new JLabel("Strength:", 4), ParagraphLayout.NEW_PARAGRAPH);
            this.strengthSlider = SliderFactory.createPercentageSlider();
            this.add(this.strengthSlider);
            this.strengthSlider.addChangeListener(this);
            this.showSourceCheck = new JCheckBox("Show Source: ");
            this.add((Component)this.showSourceCheck, ParagraphLayout.NEW_LINE);
            this.showSourceCheck.addChangeListener(this);
            this.showDestCheck = new JCheckBox("Show Destination: ");
            this.add(this.showDestCheck);
            this.showDestCheck.addChangeListener(this);
        }

        public void setObject(Object o) {
            this.tool = (FieldWarpTool)o;
            this.showSourceCheck.setSelected(FieldWarpTool.this.showSource);
            this.showDestCheck.setSelected(FieldWarpTool.this.showDest);
            this.amountSlider.setValue((int)(FieldWarpTool.this.filter.getAmount() * 100.0f));
            this.powerSlider.setValue((int)(FieldWarpTool.this.filter.getPower() * 100.0f));
            this.strengthSlider.setValue((int)(FieldWarpTool.this.filter.getStrength() * 100.0f));
        }

        public void stateChanged(ChangeEvent e) {
            if (this.tool != null) {
                Object source = e.getSource();
                if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                    return;
                }
                if (source == this.showSourceCheck) {
                    FieldWarpTool.this.showSource = this.showSourceCheck.isSelected();
                } else if (source == this.showSourceCheck) {
                    FieldWarpTool.this.showDest = this.showDestCheck.isSelected();
                } else if (source == this.amountSlider) {
                    FieldWarpTool.this.filter.setAmount((float)this.amountSlider.getValue() / 100.0f);
                } else if (source == this.powerSlider) {
                    FieldWarpTool.this.filter.setPower((float)this.powerSlider.getValue() / 100.0f);
                } else if (source == this.strengthSlider) {
                    FieldWarpTool.this.filter.setStrength((float)this.strengthSlider.getValue() / 100.0f);
                }
                if (source == this.amountSlider || source == this.powerSlider || source == this.strengthSlider) {
                    FieldWarpTool.this.doEndDrag();
                } else {
                    FieldWarpTool.this.view.repaint();
                }
            }
        }
    }
}

