/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.tool.SelectionTool;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class LassooTool
extends SelectionTool {
    private Polygon path;
    private int freezeX;
    private int freezeY;
    private int firstX;
    private int firstY;
    private boolean polygonMode = true;

    public boolean doStartDrag() {
        boolean b = super.doStartDrag();
        if (b) {
            this.polygonMode = this.event.isMetaDown();
            if (this.path == null) {
                this.path = new Polygon();
            }
            if (this.polygonMode) {
                if (this.path.npoints == 0) {
                    this.path.addPoint(this.view.XTox(this.currX), this.view.YToy(this.currY));
                    this.freezeX = this.currX;
                    this.freezeY = this.currY;
                    this.firstX = this.currX;
                    this.firstY = this.currY;
                }
            } else {
                this.path = new Polygon();
                this.path.addPoint(this.view.XTox(this.currX), this.view.YToy(this.currY));
                this.freezeX = this.currX;
                this.freezeY = this.currY;
            }
        }
        return true;
    }

    public void doDrag(boolean erase) {
        if (this.polygonMode) {
            this.graphics.drawLine(this.freezeX, this.freezeY, this.currX, this.currY);
        } else if (!erase) {
            this.graphics.drawLine(this.freezeX, this.freezeY, this.currX, this.currY);
            this.path.addPoint(this.view.XTox(this.currX), this.view.YToy(this.currY));
            this.freezeX = this.currX;
            this.freezeY = this.currY;
        }
    }

    public void doEndDrag() {
        if (this.polygonMode) {
            this.graphics.drawLine(this.freezeX, this.freezeY, this.currX, this.currY);
            if (this.path.npoints > 0 && Math.abs(this.currX - this.firstX) < 3 && Math.abs(this.currY - this.firstY) < 3) {
                this.finishLassoo();
            } else {
                if (this.path.npoints == 0) {
                    this.firstX = this.currX;
                    this.firstY = this.currY;
                }
                this.path.addPoint(this.view.XTox(this.currX), this.view.YToy(this.currY));
                this.freezeX = this.currX;
                this.freezeY = this.currY;
            }
        } else {
            this.finishLassoo();
        }
    }

    public void finishLassoo() {
        boolean clear = !this.event.isShiftDown() && !this.event.isControlDown();
        this.path.addPoint(this.view.XTox(this.currX), this.view.YToy(this.currY));
        Rectangle r = this.path.getBounds();
        BufferedImage selection = this.view.getSelection();
        Composition composition = this.view.getComposition();
        Rectangle bounds = composition.getSelectedBounds();
        if (clear) {
            composition.selectNone();
        }
        Graphics2D g = selection.createGraphics();
        if (this.event.isControlDown()) {
            g.setComposite(AlphaComposite.getInstance(1));
        } else {
            g.setColor(new Color(-16777216));
            g.setComposite(AlphaComposite.getInstance(2));
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillPolygon(this.path);
        g.dispose();
        if (clear && bounds != null) {
            r = r.union(bounds);
        }
        composition.startUpdate();
        composition.updateSelection(r);
        composition.endUpdate(false);
        this.path = null;
    }

    public char getShortcutKey() {
        return 'l';
    }

    public String getToolTipText() {
        return "Lassoo Selection Tool";
    }

    public String getHelpText() {
        return "Lassoo Selection Tool: Shift key adds to the selection, Control key subtracts";
    }
}

