/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.Tool;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JViewport;

public class PanTool
extends Tool {
    private JViewport viewport;
    private Point pos;
    private Dimension viewSize;
    private Dimension extentSize;
    private static Cursor cursor;

    public boolean doStartDrag() {
        this.viewport = null;
        for (Container c = this.view.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JViewport)) continue;
            this.viewport = (JViewport)c;
            this.pos = this.viewport.getViewPosition();
            this.viewSize = this.viewport.getViewSize();
            this.extentSize = this.viewport.getExtentSize();
            break;
        }
        return true;
    }

    public void doDrag(boolean erase) {
        if (!erase && this.viewport != null) {
            Point p = this.viewport.getViewPosition();
            p.x -= this.currX - this.startX;
            p.y -= this.currY - this.startY;
            p.x = Math.max(0, p.x);
            p.y = Math.max(0, p.y);
            p.x = Math.min(this.viewSize.width - this.extentSize.width, p.x);
            p.y = Math.min(this.viewSize.height - this.extentSize.height, p.y);
            this.viewport.setViewPosition(p);
        }
    }

    public void setCursor(Component c) {
        if (cursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(this.getClass().getResource("PanTool.gif"));
            cursor = toolkit.createCustomCursor(image, new Point(12, 14), "tool");
        }
        c.setCursor(cursor);
    }

    public char getShortcutKey() {
        return 'p';
    }

    public String getToolTipText() {
        return "Panning Tool";
    }
}

