/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.app.Application;
import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.tool.DrawShapeTool;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.XMLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ShapeTool
extends DrawShapeTool {
    private Vector shapes = new Vector();
    private Shape shape;
    private double innerRadius = 0.4;

    public ShapeTool() {
        try {
            PluginIterator it = new PluginIterator("Shapes");
            while (it.hasNext()) {
                try {
                    File file = (File)it.next();
                    System.out.println(file);
                    if (!file.getName().toLowerCase().endsWith(".xml")) continue;
                    XMLDecoder decoder = new XMLDecoder(new FileInputStream(file));
                    this.shapes.add((Shape)decoder.readObject());
                    decoder.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.shapes.size() > 0) {
            this.shape = (Shape)this.shapes.get(0);
        }
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Shape makeShape() {
        Rectangle r = this.getRectangle();
        AffineTransform t = new AffineTransform();
        t.translate(r.x, r.y);
        t.scale(r.width, r.height);
        return t.createTransformedShape(this.shape);
    }

    public String getToolTipText() {
        return "Shape Tool";
    }

    public String getHelpText() {
        return "Shape Tool: Meta key picks color";
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new ShapeToolCustomizer();
    }

    class PluginIterator
    implements Iterator {
        private String base;
        private File[] roots = new File[4];
        private int index = -1;
        private FileIterator iterator;

        public PluginIterator(String base) {
            this.base = base;
            Application application = Application.getInstance();
            if (application.isMacintosh()) {
                String library = "/Library/Application Support/" + application.getApplicationName() + "/" + base;
                try {
                    this.roots[1] = new File(System.getProperty("user.home"), library);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                this.roots[2] = new File(library);
            }
            this.roots[0] = new File(application.getProperty("pluginsFolder", base));
            this.advance();
        }

        private void advance() {
            while (true) {
                ++this.index;
                if (this.index < this.roots.length && this.roots[this.index] == null) continue;
                this.iterator = this.index < this.roots.length ? new FileIterator(this.roots[this.index]) : null;
                if (this.iterator == null || this.iterator.hasNext()) break;
            }
        }

        public boolean hasNext() {
            return this.iterator != null;
        }

        public Object next() {
            Object o = this.iterator.next();
            if (!this.iterator.hasNext()) {
                this.advance();
            }
            return o;
        }

        public void remove() {
        }
    }

    class FileIterator
    implements Iterator {
        private File dir;
        private String[] files;
        private int index = 0;

        public FileIterator(File dir) {
            System.out.println("FileIt: " + dir);
            this.dir = dir;
            this.files = dir.list();
        }

        public boolean hasNext() {
            return this.files != null && this.index < this.files.length;
        }

        public Object next() {
            return new File(this.dir, this.files[this.index++]);
        }

        public void remove() {
        }
    }

    class ShapeToolCustomizer
    extends DrawShapeTool.DrawShapeToolCustomizer
    implements ActionListener {
        private ShapeTool tool;
        private JComboBox shapeCombo;

        public ShapeToolCustomizer() {
            this.setLayout(new SuperGridLayout(1, 0));
            this.add(new JLabel("Shape:", 4));
            this.shapeCombo = new JComboBox(ShapeTool.this.shapes);
            this.add(this.shapeCombo);
            this.shapeCombo.addActionListener(this);
        }

        public void setObject(Object o) {
            this.tool = (ShapeTool)o;
            this.shapeCombo.setSelectedItem(this.tool.getShape());
            super.setObject(o);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.tool != null && source == this.shapeCombo) {
                this.tool.setShape((Shape)this.shapeCombo.getSelectedItem());
            }
            super.actionPerformed(e);
        }
    }
}

