/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.tool.DrawShapeTool;
import com.jhlabs.swing.SliderFactory;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StarTool
extends DrawShapeTool {
    public static final int POLYGON = 0;
    public static final int STAR = 1;
    private int sides = 6;
    private int shape = 0;
    private double innerRadius = 0.4;

    public void setSides(int sides) {
        this.sides = sides;
    }

    public int getSides() {
        return this.sides;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public int getShape() {
        return this.shape;
    }

    public void setInnerRadius(double innerRadius) {
        this.innerRadius = innerRadius;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void doDrag(boolean erase) {
        this.graphics.draw(this.makeShape(this.startX, this.startY, this.currX, this.currY));
    }

    public String getToolTipText() {
        return "Star Tool";
    }

    public String getHelpText() {
        return "Star Tool: Meta key picks color";
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new StarToolCustomizer();
    }

    public Shape makeShape() {
        return this.makeShape(this.view.XTox(this.startX), this.view.YToy(this.startY), this.view.XTox(this.currX), this.view.YToy(this.currY));
    }

    private Shape makeShape(float cx, float cy, float rx, float ry) {
        double dx = rx - cx;
        double dy = ry - cy;
        double startAngle = Math.atan2(dy, dx);
        double radius = Math.sqrt(dx * dx + dy * dy);
        GeneralPath path = new GeneralPath();
        int n = this.shape == 0 ? this.sides : 2 * this.sides;
        for (int i = 0; i < n; ++i) {
            double angle = startAngle + (double)(i * 2) * Math.PI / (double)n;
            double r = this.shape == 0 ? radius : radius * ((i & 1) != 0 ? this.innerRadius : 1.0);
            float x = (float)((double)cx + r * Math.cos(angle));
            float y = (float)((double)cy + r * Math.sin(angle));
            if (i == 0) {
                path.moveTo(x, y);
                continue;
            }
            path.lineTo(x, y);
        }
        path.closePath();
        return path;
    }

    class StarToolCustomizer
    extends DrawShapeTool.DrawShapeToolCustomizer
    implements ChangeListener {
        private StarTool tool;
        private JSpinner repetitionsField;
        private JSlider innerRadiusSlider;
        private JRadioButton polygonRadio;
        private JRadioButton starRadio;

        public StarToolCustomizer() {
            this.setLayout(new SuperGridLayout(1, 0));
            this.add(new JLabel("Shape:", 4));
            this.polygonRadio = new JRadioButton("Polygon");
            this.starRadio = new JRadioButton("Star");
            this.polygonRadio.addChangeListener(this);
            this.starRadio.addChangeListener(this);
            ButtonGroup group = new ButtonGroup();
            group.add(this.polygonRadio);
            group.add(this.starRadio);
            this.add(this.polygonRadio);
            this.add(this.starRadio);
            this.add(new JLabel("Repetitions:", 4));
            Integer value = new Integer(6);
            Integer min = new Integer(3);
            Integer max = new Integer(100);
            Integer step = new Integer(1);
            SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
            this.repetitionsField = new JSpinner(model);
            this.repetitionsField.addChangeListener(this);
            this.add(this.repetitionsField);
            this.add(new JLabel("Inner Radius:", 4));
            this.innerRadiusSlider = SliderFactory.createPercentageSlider(false);
            this.innerRadiusSlider.addChangeListener(this);
            this.add(this.innerRadiusSlider);
        }

        public void setObject(Object o) {
            this.tool = (StarTool)o;
            this.repetitionsField.setValue(new Integer(this.tool.getSides()));
            this.innerRadiusSlider.setValue((int)(this.tool.getInnerRadius() * 100.0));
            if (this.tool.getShape() == 1) {
                this.starRadio.setSelected(true);
            } else {
                this.polygonRadio.setSelected(true);
            }
            super.setObject(o);
        }

        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (this.tool != null) {
                if (source == this.innerRadiusSlider) {
                    this.tool.setInnerRadius((double)this.innerRadiusSlider.getValue() / 100.0);
                } else if (source == this.polygonRadio) {
                    this.tool.setShape(0);
                } else if (source == this.starRadio) {
                    this.tool.setShape(1);
                } else if (source == this.repetitionsField) {
                    this.tool.setSides(((SpinnerNumberModel)this.repetitionsField.getModel()).getNumber().intValue());
                }
            }
            super.stateChanged(e);
        }
    }
}

