/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.ie.ui.ColorChooser;
import com.jhlabs.image.ImageMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;

class ColorCanvas
extends JComponent {
    protected Image image;
    protected boolean newImage = true;
    protected MemoryImageSource source;
    protected int maxX = 255;
    protected int maxY = 255;
    protected int maxZ = 255;
    protected int selX;
    protected int selY;
    protected float selZ = 1.0f;
    protected boolean hueBar = false;
    protected ColorChooser chooser;

    public ColorCanvas(ColorChooser chooser, boolean hueBar) {
        this.chooser = chooser;
        this.hueBar = hueBar;
        this.enableEvents(16L);
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        int w = size.width;
        int h = size.height;
        int x = this.selX * size.width / this.maxX;
        int y = this.selY * size.height / this.maxY;
        if (this.newImage || this.image == null) {
            this.image = this.makeImage(this.selZ, w, h);
        }
        g.drawImage(this.image, 0, 0, w, h, this);
        g.setColor(Color.white);
        g.drawLine(x - 8, y, x + 8, y);
        g.drawLine(x, y - 8, x, y + 8);
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, this.hueBar ? 32 : 100);
    }

    private void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    private void setXY(int x, int y) {
        this.selX = x;
        this.selY = y;
        this.repaint();
    }

    private int getSelectedX() {
        return this.selX;
    }

    private int getSelectedY() {
        return this.selY;
    }

    protected void doMouseEvent(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Dimension size = this.getSize();
        int newSelX = x * this.maxX / size.width;
        int newSelY = y * this.maxY / size.height;
        newSelX = ImageMath.clamp(newSelX, 0, this.maxX);
        newSelY = ImageMath.clamp(newSelY, 0, this.maxY);
        if (newSelX != this.selX || newSelY != this.selY) {
            this.selX = newSelX;
            this.selY = newSelY;
            this.repaint();
            this.chooser.colorChanged(this);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                this.doMouseEvent(e);
                this.enableEvents(48L);
                break;
            }
            case 502: {
                this.doMouseEvent(e);
                this.enableEvents(16L);
            }
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        switch (e.getID()) {
            case 506: {
                this.doMouseEvent(e);
            }
        }
        super.processMouseMotionEvent(e);
    }

    private Image makeImage(float b, int w, int h) {
        int[] pixels = new int[w * h];
        int i = 0;
        float hue = 0.0f;
        float sat = 0.0f;
        float bri = 0.0f;
        if (this.hueBar) {
            sat = 1.0f;
        } else {
            hue = b;
        }
        for (int y = 0; y < h; ++y) {
            bri = (float)y / (float)h;
            for (int x = 0; x < w; ++x) {
                if (this.hueBar) {
                    hue = (float)x / (float)w;
                } else {
                    sat = (float)x / (float)w;
                }
                pixels[i++] = 0xFF000000 | Color.HSBtoRGB(hue, sat, bri);
            }
        }
        this.newImage = false;
        if (this.image == null) {
            this.source = new MemoryImageSource(w, h, ColorModel.getRGBdefault(), pixels, 0, w);
            this.image = this.createImage(this.source);
            this.source.setAnimated(true);
        } else {
            this.source.newPixels(pixels, ColorModel.getRGBdefault(), 0, w);
        }
        return this.image;
    }

    public void setColor(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        if (this.hueBar) {
            this.selZ = hsb[1];
            this.setXY((int)(255.0f * hsb[0]), (int)(255.0f * hsb[2]));
        } else {
            this.selZ = hsb[0];
            this.setXY((int)(255.0f * hsb[1]), (int)(255.0f * hsb[2]));
        }
        this.repaintImage();
    }

    public Color getColor() {
        float h = this.hueBar ? (float)this.selX / 255.0f : this.selZ;
        float s = this.hueBar ? 1.0f : (float)this.selX / 255.0f;
        float b = (float)this.selY / 255.0f;
        return Color.getHSBColor(h, s, b);
    }

    private void repaintImage() {
        this.newImage = true;
        this.repaint();
    }
}

