/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.image.PaintingContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class ColorSwatches
extends JComponent {
    private int selected = 0;
    private int rows = 12;
    private int cols = 18;
    private int gap = 0;
    private int margin = 2;
    private int cellSize = 8;
    private Color[] palette;
    private int[] levels = new int[]{0, 51, 102, 153, 204, 255};

    public ColorSwatches() {
        this.setWebPalette();
        this.enableEvents(16L);
    }

    public void setWebPalette() {
        int b;
        int g;
        int r;
        int index = 0;
        this.palette = new Color[216];
        for (r = 0; r < 6; ++r) {
            for (g = 0; g < 3; ++g) {
                for (b = 0; b < 6; ++b) {
                    this.palette[index++] = new Color(this.levels[r], this.levels[g], this.levels[b]);
                }
            }
        }
        for (r = 0; r < 6; ++r) {
            for (g = 3; g < 6; ++g) {
                for (b = 0; b < 6; ++b) {
                    this.palette[index++] = new Color(this.levels[r], this.levels[g], this.levels[b]);
                }
            }
        }
        this.repaint();
    }

    public void setPalette(Color[] palette) {
        this.palette = palette;
        this.repaint();
    }

    public Color[] getPalette() {
        return this.palette;
    }

    public Color getColor() {
        return this.palette[this.selected];
    }

    public Color getColorAt(int row, int col) {
        int index = row * this.cols + col;
        if (0 <= index && index < this.palette.length) {
            return this.palette[index];
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(2 * this.margin + this.cols * (this.cellSize + this.gap) - this.gap, 2 * this.margin + this.rows * (this.cellSize + this.gap) - this.gap);
    }

    public void paintComponent(Graphics g) {
        for (int r = 0; r < this.rows; ++r) {
            int y = this.margin + r * (this.cellSize + this.gap);
            for (int c = 0; c < this.cols; ++c) {
                int x = this.margin + c * (this.cellSize + this.gap);
                Color color = this.getColorAt(r, c);
                if (color == null) continue;
                g.setColor(color);
                g.fillRect(x, y, this.cellSize, this.cellSize);
                g.setColor(Color.black);
                g.drawRect(x, y, this.cellSize, this.cellSize);
            }
        }
    }

    protected void doMouseEvent(MouseEvent e) {
        int col;
        int x = e.getX();
        int y = e.getY();
        int row = (y - this.margin) / (this.cellSize + this.gap);
        Color color = this.getColorAt(row, col = (x - this.margin) / (this.cellSize + this.gap));
        if (color != null) {
            Color oldColor = this.getColor();
            this.selected = row * this.cols + col;
            PaintingContext.getInstance().setFgColor(this.getColor().getRGB());
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                this.doMouseEvent(e);
                this.enableEvents(48L);
                break;
            }
            case 502: {
                this.doMouseEvent(e);
                this.enableEvents(16L);
            }
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        switch (e.getID()) {
            case 506: {
                this.doMouseEvent(e);
            }
        }
        super.processMouseMotionEvent(e);
    }
}

