/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.Application;
import com.jhlabs.awt.ParagraphLayout;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.Palette;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoPalette
extends JPanel
implements Palette {
    private CompositionApplication application;
    private JLabel xLabel;
    private JLabel yLabel;
    private JLabel wLabel;
    private JLabel hLabel;
    private static final DecimalFormat format = new DecimalFormat("####");
    public static InfoPalette instance;
    private static final Font SMALL_FONT;
    public static final int INFO_XY = 1;
    public static final int INFO_XYWH = 2;
    public static final int INFO_XYDXDY = 3;
    public static final int INFO_XYRA = 4;
    private int type = 0;

    public InfoPalette() {
        instance = this;
        this.application = (CompositionApplication)CompositionApplication.getInstance();
        this.setLayout(new ParagraphLayout(5, 5, 4, 4, 4, 4));
        this.add((Component)new JLabel("X:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.xLabel = new JLabel("");
        this.add(this.xLabel);
        this.add(new JLabel("Y:", 4));
        this.yLabel = new JLabel();
        this.add(this.yLabel);
        this.add((Component)new JLabel("W:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.wLabel = new JLabel();
        this.add(this.wLabel);
        this.add(new JLabel("H:", 4));
        this.hLabel = new JLabel();
        this.add(this.hLabel);
        format.setMinimumIntegerDigits(4);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            this.getComponent(i).setFont(SMALL_FONT);
        }
        this.setMouseInfo(2, 0, 0, 0, 0);
    }

    public void startup(Application application) {
        this.addPropertyChangeListener((CompositionApplication)application);
    }

    public void shutdown() {
    }

    public void setMouseInfo(int type, int x, int y, int w, int h) {
        this.type = type;
        this.xLabel.setText(this.format(x));
        this.yLabel.setText(this.format(y));
        this.wLabel.setText(this.format(w));
        this.hLabel.setText(this.format(h));
    }

    private String format(int n) {
        String s = Integer.toString(n);
        int length = s.length();
        StringBuffer sb = new StringBuffer();
        while (5 > length++) {
            sb.append(' ');
        }
        sb.append(s);
        return sb.toString();
    }

    public String getName() {
        return "showInfo";
    }

    static {
        SMALL_FONT = new Font("dialog", 0, 9);
    }
}

