/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.Application;
import com.jhlabs.awt.DoubleClickAdapter;
import com.jhlabs.composite.MiscComposite;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.CompositionController;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.CompositionEvent;
import com.jhlabs.ie.CompositionListener;
import com.jhlabs.ie.LayerTransferable;
import com.jhlabs.ie.Palette;
import com.jhlabs.ie.layer.Layer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LayerPanel
extends JPanel
implements Palette,
PropertyChangeListener,
ChangeListener,
ActionListener,
ListSelectionListener,
CompositionListener {
    protected CompositionApplication application;
    protected CompositionDocument document;
    protected Composition composition;
    protected JList list;
    private JScrollPane scrollPane;
    private JSlider opacity;
    private ListSelectionModel selectionModel;
    private JRadioButtonMenuItem[] modeItems;
    private boolean selecting = false;
    static Paint selectedPaint = new GradientPaint(0.0f, 0.0f, new Color(40, 142, 255), 0.0f, 32.0f, new Color(122, 234, 255));
    static Paint unselectedPaint = new GradientPaint(0.0f, 0.0f, new Color(210, 210, 210), 0.0f, 32.0f, new Color(240, 240, 240));

    public LayerPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("Layers");
        fileMenu.setIcon(new ImageIcon(this.getClass().getResource("menu.png")));
        menuBar.add(fileMenu);
        LayerPanel layerPanel = this;
        CompositionController controller = ((CompositionApplication)layerPanel.application.getInstance()).getCompositionController();
        fileMenu.add(controller.newLayerAction);
        fileMenu.add(controller.deleteLayerAction);
        fileMenu.add(controller.duplicateLayerAction);
        fileMenu.add(controller.renameLayerAction);
        fileMenu.add(controller.moveLayerUpAction);
        fileMenu.add(controller.moveLayerDownAction);
        fileMenu.add(controller.mergeLayerDownAction);
        JMenu modeMenu = new JMenu("Blend Mode");
        ButtonGroup group = new ButtonGroup();
        fileMenu.add(modeMenu);
        this.modeItems = new JRadioButtonMenuItem[MiscComposite.RULE_NAMES.length];
        for (int i = 0; i < MiscComposite.RULE_NAMES.length; ++i) {
            this.modeItems[i] = new JRadioButtonMenuItem(MiscComposite.RULE_NAMES[i]);
            modeMenu.add(this.modeItems[i]);
            this.modeItems[i].addActionListener(this);
            group.add(this.modeItems[i]);
        }
        this.add((Component)menuBar, "North");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)new JLabel("Opacity: ", 4), "West");
        this.opacity = new JSlider(0, 0, 255, 0);
        p.add((Component)this.opacity, "Center");
        this.opacity.setPaintTicks(true);
        this.opacity.setMajorTickSpacing(255);
        this.opacity.setMinorTickSpacing(64);
        this.opacity.addChangeListener(this);
        this.add((Component)p, "South");
        this.list = new LayerList();
        this.list.setSelectionMode(0);
        this.list.setFont(new Font("sansserif", 0, 11));
        this.scrollPane = new JScrollPane(this.list);
        this.add((Component)this.scrollPane, "Center");
        this.list.setCellRenderer(new LayerCellRenderer());
        this.list.addMouseListener(new ClickAdapter());
        new DoubleClickAdapter(this, this.list);
        this.selectionModel = this.list.getSelectionModel();
        this.selectionModel.addListSelectionListener(this);
        this.setPreferredSize(new Dimension(150, 300));
    }

    public void startup(Application application) {
        application.addPropertyChangeListener(this);
    }

    public void shutdown() {
    }

    public String getName() {
        return "showLayers";
    }

    public void setDocument(CompositionDocument document) {
        if (document != this.document) {
            if (this.composition != null) {
                this.composition.removeCompositionListener(this);
            }
            this.document = document;
            Composition composition = this.composition = document != null ? document.getComposition() : null;
            if (this.composition == null) {
                this.list.setModel(new DefaultListModel());
            } else {
                this.list.setModel(new ReversedListModel(this.composition.getLayersModel()));
                this.list.setSelectedValue(this.composition.getActiveLayer(), true);
                this.composition.addCompositionListener(this);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("currentDocument".equals(name)) {
            this.setDocument((CompositionDocument)event.getNewValue());
        }
    }

    public void imageChanged(CompositionEvent e) {
        if (e.getID() == 4 && !this.selecting) {
            this.list.setSelectedValue(this.composition.getActiveLayer(), true);
        }
    }

    private Layer selectedLayer() {
        return (Layer)this.list.getSelectedValue();
    }

    private void itemSelected() {
        this.selecting = true;
        Layer layer = this.selectedLayer();
        for (int i = 0; i < this.modeItems.length; ++i) {
            this.modeItems[i].setEnabled(layer != null);
        }
        if (layer != null) {
            int index = this.list.getLeadSelectionIndex();
            this.opacity.setValue(layer.getOpacity());
            this.opacity.setEnabled(true);
            this.modeItems[layer.getOperation()].setSelected(true);
        } else {
            this.opacity.setEnabled(false);
        }
        if (this.document != null) {
            this.document.setActiveLayer(layer);
        }
        this.selecting = false;
    }

    private void doPaintMode(int mode) {
        Layer layer = this.selectedLayer();
        layer.setOperation(mode);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        for (int i = 0; i < this.modeItems.length; ++i) {
            if (source != this.modeItems[i]) continue;
            this.doPaintMode(i);
            break;
        }
        this.composition.startUpdate();
        this.composition.updateAll();
        this.composition.endUpdate();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.itemSelected();
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        Layer layer = this.selectedLayer();
        if (layer != null) {
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.opacity && !this.selecting) {
                layer.setOpacity(this.opacity.getValue());
                this.composition.startUpdate();
                this.composition.updateAll();
                this.composition.endUpdate();
            }
        }
    }

    class LayerCellRenderer
    extends JComponent
    implements ListCellRenderer {
        private Icon icon = new ImageIcon(this.getClass().getResource("layer.gif"));
        private Layer layer;
        private boolean selected;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.layer = (Layer)value;
            Dimension size = this.getSize();
            this.setPreferredSize(new Dimension(size.width, 32));
            this.selected = isSelected;
            return this;
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.selected ? selectedPaint : unselectedPaint);
            Dimension size = this.getSize();
            g2d.fillRect(0, 0, size.width, size.height);
            g2d.setColor(Color.black);
            Icon ic = this.layer.getIcon();
            if (ic == null) {
                ic = this.icon;
            }
            ic.paintIcon(this, g2d, 2, 8);
            BufferedImage image = this.layer.getImage();
            if (image != null) {
                g.drawImage(image, 20, size.height / 2 - 12, 32, 24, this);
            }
            if (this.layer.getName() != null) {
                g.drawString(this.layer.getName(), 54, 20);
            }
            this.paintTick(g, size.width - 18, size.height / 2 - 8, this.layer.isVisible(), true);
        }

        private void paintTick(Graphics g, int x, int y, boolean ticked, boolean enabled) {
            if (ticked) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(enabled ? Color.black : Color.gray);
                BasicStroke bs = new BasicStroke(2.0f, 1, 1, 10.0f, null, 0.0f);
                g2d.setStroke(bs);
                g.drawLine(x + 5, y + 9, x + 7, y + 11);
                g.drawLine(x + 7, y + 11, x + 13, y + 5);
            }
        }
    }

    private class ClickAdapter
    extends MouseAdapter {
        private ClickAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            int index = LayerPanel.this.list.locationToIndex(new Point(e.getX(), e.getY()));
            if (LayerPanel.this.composition != null && index != -1) {
                Layer layer;
                Rectangle cellBounds = LayerPanel.this.list.getCellBounds(index, index);
                ListModel model = LayerPanel.this.list.getModel();
                if (index >= 0 && index < model.getSize() && (layer = (Layer)LayerPanel.this.list.getModel().getElementAt(index)) != null) {
                    int x = (cellBounds.x + cellBounds.width - e.getX()) / 16;
                    switch (x) {
                        case 0: {
                            layer.setVisible(!layer.isVisible());
                            LayerPanel.this.composition.startUpdate();
                            LayerPanel.this.composition.updateAll();
                            LayerPanel.this.composition.endUpdate();
                            LayerPanel.this.list.repaint();
                            break;
                        }
                        default: {
                            if (!e.isMetaDown() && !e.isAltDown()) break;
                            LayerPanel.this.composition.selectionFromAlpha(layer);
                            e.consume();
                        }
                    }
                }
            }
        }
    }

    static class ReversedListModel
    implements ListModel {
        private ListModel delegate;

        public ReversedListModel(ListModel delegate) {
            this.delegate = delegate;
        }

        public int getSize() {
            return this.delegate.getSize();
        }

        public Object getElementAt(int index) {
            return this.delegate.getElementAt(this.delegate.getSize() - 1 - index);
        }

        public void addListDataListener(ListDataListener listener) {
            this.delegate.addListDataListener(listener);
        }

        public void removeListDataListener(ListDataListener listener) {
            this.delegate.removeListDataListener(listener);
        }
    }

    class LayerList
    extends JList
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private DragSource dragSource = DragSource.getDefaultDragSource();
        private DragSourceContext dragSourceContext = null;
        private int dragInsert = -1;

        public LayerList() {
            DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
            DropTarget dropTarget = new DropTarget(this, this);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.dragInsert != -1) {
                Point p = this.indexToLocation(this.dragInsert);
                int y = p == null ? this.indexToLocation((int)(this.dragInsert - 1)).y + 31 : p.y;
                g.setColor(Color.black);
                g.drawLine(0, y, this.getWidth(), y);
                g.drawLine(0, y + 1, this.getWidth(), y + 1);
            }
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            Layer layer = (Layer)this.getSelectedValue();
            if (layer != null) {
                LayerTransferable transferable = new LayerTransferable(layer);
                Cursor cursor = DragSource.DefaultCopyNoDrop;
                int action = e.getDragAction();
                if (action == 2) {
                    cursor = DragSource.DefaultMoveNoDrop;
                }
                this.dragSource.startDrag(e, cursor, transferable, this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dsde) {
        }

        public void drop(DropTargetDropEvent e) {
            try {
                Transferable tr = e.getTransferable();
                if (tr.isDataFlavorSupported(LayerTransferable.LAYER_FLAVOR)) {
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    Layer layer = (Layer)tr.getTransferData(LayerTransferable.LAYER_FLAVOR);
                    if (this.dragInsert != -1) {
                        LayerPanel.this.document.doReorderLayer(layer, this.getModel().getSize() - this.dragInsert, false);
                        this.setSelectedValue(LayerPanel.this.composition.getActiveLayer(), true);
                        LayerPanel.this.composition.startUpdate();
                        LayerPanel.this.composition.updateAll();
                        LayerPanel.this.composition.endUpdate();
                        this.dragInsert = -1;
                    }
                }
            }
            catch (Exception ex) {
                e.rejectDrop();
            }
        }

        public void dragEnter(DropTargetDragEvent e) {
            if (e.isDataFlavorSupported(LayerTransferable.LAYER_FLAVOR)) {
                this.dragInsert = this.getDragInsert(e.getLocation());
                this.repaint();
            }
        }

        public void dragExit(DropTargetEvent e) {
            if (this.dragInsert != -1) {
                this.dragInsert = -1;
                this.repaint();
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            int row;
            if (e.isDataFlavorSupported(LayerTransferable.LAYER_FLAVOR) && (row = this.getDragInsert(e.getLocation())) != this.dragInsert) {
                this.dragInsert = row;
                this.repaint();
            }
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        private int getDragInsert(Point p) {
            if (p.y < 16) {
                return 0;
            }
            p.y -= 16;
            return this.locationToIndex(p) + 1;
        }
    }
}

