/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.DialogController;
import com.jhlabs.app.SimpleRadioPanel;
import com.jhlabs.awt.ButtonLayout;
import com.jhlabs.awt.ParagraphLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class NewImageDialog
extends DialogController
implements DocumentListener,
ActionListener {
    private JTextField widthText;
    private JTextField heightText;
    private int width;
    private int height;
    private SimpleRadioPanel colorPanel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean ok = false;

    public NewImageDialog(Frame frame, int width, int height) {
        super(frame, "New Image", false, true);
        this.width = width;
        this.height = height;
        JPanel p = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)p, "North");
        p.setBorder(new EmptyBorder(10, 10, 10, 0));
        p.setLayout(new ParagraphLayout());
        p.add((Component)new JLabel("Width:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.widthText = new JTextField(4);
        p.add(this.widthText);
        p.add(new JLabel("pixels"));
        p.add((Component)new JLabel("Height:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.heightText = new JTextField(4);
        p.add(this.heightText);
        p.add(new JLabel("pixels"));
        this.widthText.setText(Integer.toString(width));
        this.heightText.setText(Integer.toString(height));
        this.widthText.getDocument().addDocumentListener(this);
        this.heightText.getDocument().addDocumentListener(this);
        this.widthText.addActionListener(this);
        this.heightText.addActionListener(this);
        this.colorPanel = new SimpleRadioPanel("Background", new String[]{"Transparent", "White", "Background Color"});
        this.colorPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.colorPanel, "Center");
        p = new JPanel();
        this.getContentPane().add((Component)p, "South");
        p.setLayout(new ButtonLayout());
        this.cancelButton = new JButton("Cancel");
        p.add(this.cancelButton);
        this.okButton = new JButton("OK");
        p.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    public Dimension showDialog() {
        this.okButton.setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewImageDialog.this.widthText.requestFocus();
                NewImageDialog.this.widthText.selectAll();
            }
        });
        this.setVisible(true);
        return this.ok ? new Dimension(this.width, this.height) : null;
    }

    public int getBackground() {
        return this.colorPanel.getSelectedIndex();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cancelButton) {
            this.setVisible(false);
        } else if (source == this.okButton || source == this.widthText || source == this.heightText) {
            this.ok = true;
            this.setVisible(false);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void textValueChanged(DocumentEvent event) {
        Document document = event.getDocument();
        try {
            if (document == this.widthText.getDocument()) {
                this.width = Integer.parseInt(this.widthText.getText());
            } else if (document == this.heightText.getDocument()) {
                this.height = Integer.parseInt(this.heightText.getText());
            }
            if (this.width >= 1 && this.width <= 2048 && this.height >= 1 && this.height <= 2048) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.getToolkit().beep();
                this.okButton.setEnabled(false);
            }
        }
        catch (NumberFormatException e) {
            this.okButton.setEnabled(false);
        }
    }
}

