/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.Application;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.Palette;
import com.jhlabs.ie.ui.ColorSwatches;
import com.jhlabs.image.Colormap;
import com.jhlabs.image.ColormapTransferable;
import com.jhlabs.image.OctTreeQuantizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PaletteColorChooser
extends JPanel
implements Palette,
ActionListener,
DropTargetListener {
    private CompositionApplication application;
    public ColorSwatches colorSwatches;
    private JMenuItem loadItem;
    private JMenuItem saveItem;
    private JMenuItem loadGradientItem;
    private JMenuItem loadImageItem;
    private JMenuItem webItem;

    public PaletteColorChooser() {
        this.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("Colors");
        fileMenu.setIcon(new ImageIcon(this.getClass().getResource("menu.png")));
        menuBar.add(fileMenu);
        this.loadItem = new JMenuItem("Load...");
        fileMenu.add(this.loadItem);
        this.saveItem = new JMenuItem("Save...");
        fileMenu.add(this.saveItem);
        fileMenu.addSeparator();
        this.webItem = new JMenuItem("Web Palette");
        fileMenu.add(this.webItem);
        this.loadImageItem = new JMenuItem("Load From Image");
        fileMenu.add(this.loadImageItem);
        this.loadItem.addActionListener(this);
        this.saveItem.addActionListener(this);
        this.webItem.addActionListener(this);
        this.loadImageItem.addActionListener(this);
        this.add((Component)menuBar, "North");
        this.colorSwatches = new ColorSwatches();
        this.add(this.colorSwatches);
        this.add((Component)this.colorSwatches, "Center");
        DropTarget dropTarget = new DropTarget(this.colorSwatches, this);
    }

    public void startup(Application application) {
        this.application = (CompositionApplication)application;
    }

    public void shutdown() {
    }

    public Color[] parsePalette(BufferedReader in) throws IOException {
        String line;
        int n = 0;
        Color[] palette = new Color[256];
        while (n < 256 && (line = in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            try {
                int r = Integer.parseInt(st.nextToken()) & 0xFF;
                int g = Integer.parseInt(st.nextToken()) & 0xFF;
                int b = Integer.parseInt(st.nextToken()) & 0xFF;
                palette[n] = new Color(0xFF000000 | r << 16 | g << 8 | b);
                ++n;
            }
            catch (NumberFormatException e) {
            }
            catch (NoSuchElementException e) {}
        }
        Color[] npalette = new Color[n];
        System.arraycopy(palette, 0, npalette, 0, n);
        return npalette;
    }

    private void loadFromFile(File file) {
        if (file != null) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                this.colorSwatches.setPalette(this.parsePalette(reader));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.application.getFrame(), "Can't read file", "Error", 0);
            }
        }
    }

    private void doLoad() {
        File file = this.application.getFileToOpen();
        if (file != null) {
            this.loadFromFile(file);
        }
    }

    private void doSave() {
        File file = this.application.getFileToSave();
        if (file != null) {
            try {
                PrintWriter fos = new PrintWriter(new FileWriter(file));
                Color[] colors = this.colorSwatches.getPalette();
                for (int i = 0; i < colors.length; ++i) {
                    int rgb = colors[i].getRGB();
                    fos.println((rgb >> 16 & 0xFF) + " " + (rgb >> 8 & 0xFF) + " " + (rgb & 0xFF));
                }
                fos.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.application.getFrame(), "Can't save file", "Error", 0);
            }
        }
    }

    private void doWebPalette() {
        this.colorSwatches.setWebPalette();
    }

    private void loadFromGradient(Colormap colormap) {
        Color[] palette = new Color[216];
        if (colormap != null) {
            for (int i = 0; i < 216; ++i) {
                palette[i] = new Color(colormap.getColor((float)i / 215.0f));
            }
            this.colorSwatches.setPalette(palette);
        }
    }

    private void doLoadFromImage() {
        Color[] palette = new Color[216];
        OctTreeQuantizer quantizer = new OctTreeQuantizer();
        CompositionDocument document = (CompositionDocument)this.application.getCurrentDocument();
        if (document != null) {
            int i;
            BufferedImage p = document.getComposition().getActiveImage();
            int[] pixels = new int[p.getWidth()];
            quantizer.setup(216);
            for (int y = 0; y < p.getHeight(); ++y) {
                p.getRGB(0, y, p.getWidth(), 1, pixels, 0, pixels.length);
                quantizer.addPixels(pixels, 0, pixels.length);
            }
            int[] table = quantizer.buildColorTable();
            int length = Math.min(216, table.length);
            for (i = 0; i < length; ++i) {
                palette[i] = new Color(table[i]);
            }
            for (i = length; i < 216; ++i) {
                palette[i] = Color.black;
            }
            this.colorSwatches.setPalette(palette);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.loadItem) {
            this.doLoad();
        } else if (source == this.saveItem) {
            this.doSave();
        } else if (source == this.webItem) {
            this.doWebPalette();
        } else if (source == this.loadImageItem) {
            this.doLoadFromImage();
        }
    }

    public String getName() {
        return "showSwatches";
    }

    public void drop(DropTargetDropEvent e) {
        try {
            Transferable transferable = e.getTransferable();
            if (transferable.isDataFlavorSupported(ColormapTransferable.COLORMAP_FLAVOR)) {
                e.acceptDrop(1);
                e.getDropTargetContext().dropComplete(true);
                Colormap colormap = (Colormap)transferable.getTransferData(ColormapTransferable.COLORMAP_FLAVOR);
                this.loadFromGradient(colormap);
            } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                e.acceptDrop(1);
                Collection files = (Collection)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (files.size() == 1) {
                    this.loadFromFile((File)files.iterator().next());
                }
            }
        }
        catch (Exception ex) {
            e.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

