/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.DialogController;
import com.jhlabs.awt.ButtonLayout;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.ui.GeneralPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class PreferencesDialog
extends DialogController
implements ActionListener {
    private CompositionApplication application;
    private GeneralPanel generalPanel;
    private JButton closeButton;
    private JButton okButton;
    private ButtonGroup toolbarGroup;
    private CardLayout cardLayout;
    private JPanel cards;
    private JToolBar toolBar;
    private Font smallSystemFont = new Font("dialog", 0, 11);

    public PreferencesDialog(CompositionApplication application) {
        super(application.getFrame(), "Preferences", false);
        this.application = application;
        this.cardLayout = new CardLayout();
        this.getContentPane().setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolbarGroup = new ButtonGroup();
        this.generalPanel = new GeneralPanel(application);
        this.generalPanel.getPreferences();
        this.cards = new JPanel();
        this.cards.setLayout(this.cardLayout);
        this.getContentPane().add((Component)this.cards, "Center");
        this.makeButton("General", "menu.png", this.generalPanel).setSelected(true);
        this.getContentPane().add((Component)this.toolBar, "North");
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new ButtonLayout());
        this.closeButton = new JButton("Cancel");
        panel.add(this.closeButton);
        this.okButton = new JButton("OK");
        panel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.pack();
    }

    private JToggleButton makeButton(final String title, String icon, JComponent pane) {
        JToggleButton b = new JToggleButton();
        b.setIcon(new ImageIcon(this.getClass().getResource(icon)));
        b.setText(title);
        b.setVerticalTextPosition(3);
        b.setHorizontalTextPosition(0);
        b.putClientProperty("Quaqua.Button.style", "toolBarTab");
        b.setFont(this.smallSystemFont);
        this.toolBar.add(b);
        this.toolbarGroup.add(b);
        this.cards.add((Component)pane, title);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.cardLayout.show(PreferencesDialog.this.cards, title);
            }
        });
        return b;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.setVisible(false);
        } else if (source == this.okButton) {
            this.generalPanel.setPreferences();
            this.setVisible(false);
        }
    }
}

