/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.ie.ui.ColormapIconFactory;
import com.jhlabs.image.Colormap;
import com.jhlabs.image.ColormapTransferable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColormapWell
extends JLabel
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private Colormap colormap = null;
    private boolean firingChangeEvent = false;
    private DragSource dragSource = null;
    private DragSourceContext dragSourceContext = null;

    public ColormapWell() {
        super("");
        DropTarget dropTarget = new DropTarget(this, this);
        this.setToolTipText("Drop gradients here");
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
        this.setText(null);
        this.setIcon(ColormapIconFactory.getIcon(colormap));
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        if (!this.firingChangeEvent) {
            this.firingChangeEvent = true;
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? ColormapWell.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
            this.firingChangeEvent = false;
        }
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        if (this.colormap != null) {
            ColormapTransferable transferable = new ColormapTransferable(this.colormap);
            Cursor cursor = DragSource.DefaultCopyNoDrop;
            int action = e.getDragAction();
            if (action == 2) {
                cursor = DragSource.DefaultMoveNoDrop;
            }
            ColormapWell colormapWell = this;
            if (colormapWell.dragSource.isDragImageSupported()) {
                Image image = ColormapIconFactory.getIcon(this.colormap).getImage().getScaledInstance(128, 12, 8);
                Point p = e.getDragOrigin();
                this.dragSource.startDrag(e, cursor, image, new Point(-p.x, -p.y), transferable, this);
            } else {
                this.dragSource.startDrag(e, cursor, transferable, this);
            }
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dsde) {
    }

    public void drop(DropTargetDropEvent e) {
        try {
            Transferable tr = e.getTransferable();
            if (tr.isDataFlavorSupported(ColormapTransferable.COLORMAP_FLAVOR)) {
                Colormap colormap = (Colormap)tr.getTransferData(ColormapTransferable.COLORMAP_FLAVOR);
                this.setColormap(colormap);
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
                e.acceptDrop(1);
                e.getDropTargetContext().dropComplete(true);
                this.fireChangeEvent();
            }
        }
        catch (Exception ex) {
            e.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(ColormapTransferable.COLORMAP_FLAVOR)) {
            this.setBorder(new MatteBorder(1, 1, 1, 1, Color.black));
        }
    }

    public void dragExit(DropTargetEvent e) {
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    public void dragOver(DropTargetDragEvent e) {
        e.acceptDrag(1);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

