/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.fill.PixelOp;

public class DDA {
    public static void drawLine(int x0, int y0, int x1, int y1, boolean drawFirst, PixelOp op) {
        int ddx = x1 < x0 ? -1 : 1;
        int ddy = y1 < y0 ? -1 : 1;
        int dx = x1 - x0;
        int dy = y1 - y0;
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        int x = x0;
        int y = y0;
        if (drawFirst) {
            op.apply(x, y);
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            int d = 2 * dy - dx;
            int incrE = 2 * dy;
            int incrNE = 2 * (dy - dx);
            while (x != x1) {
                if (d <= 0) {
                    d += incrE;
                } else {
                    d += incrNE;
                    y += ddy;
                }
                op.apply(x += ddx, y);
            }
        } else {
            int d = 2 * dx - dy;
            int incrE = 2 * dx;
            int incrNE = 2 * (dx - dy);
            while (y != y1) {
                if (d <= 0) {
                    d += incrE;
                } else {
                    d += incrNE;
                    x += ddx;
                }
                op.apply(x, y += ddy);
            }
        }
    }

    private static void circlePoints(int cx, int cy, int x, int y, PixelOp op) {
        if (x == 0) {
            op.apply(cx, cy + y);
            if (y != 0) {
                op.apply(cx, cy - y);
                op.apply(cx + y, cy);
                op.apply(cx - y, cy);
            }
        } else if (y == 0) {
            op.apply(cx + x, cy);
            op.apply(cx - x, cy);
            op.apply(cx, cy + x);
            op.apply(cx, cy - x);
        } else if (x == y) {
            op.apply(cx + x, cy + y);
            op.apply(cx - x, cy + y);
            op.apply(cx + x, cy - y);
            op.apply(cx - x, cy - y);
        } else {
            op.apply(cx + x, cy + y);
            op.apply(cx - x, cy + y);
            op.apply(cx + x, cy - y);
            op.apply(cx - x, cy - y);
            op.apply(cx + y, cy + x);
            op.apply(cx - y, cy + x);
            op.apply(cx + y, cy - x);
            op.apply(cx - y, cy - x);
        }
    }

    private static void fillCirclePoints(int cx, int cy, int x, int y, PixelOp op) {
        DDA.horizontalLine(cx - x, cx + x, cy + y, op);
        if (y != 0) {
            DDA.horizontalLine(cx - x, cx + x, cy - y, op);
        }
        if (x != y) {
            DDA.horizontalLine(cx - y, cx + y, cy + x, op);
        }
        if (x != 0) {
            DDA.horizontalLine(cx - y, cx + y, cy - x, op);
        }
    }

    private static void horizontalLine(int x1, int x2, int y, PixelOp op) {
        while (x1 <= x2) {
            op.apply(x1++, y);
        }
    }

    private static void verticalLine(int y1, int y2, int x, PixelOp op) {
        while (y1 <= y2) {
            op.apply(x, y1++);
        }
    }

    public static void drawCircle(int cx, int cy, int radius, PixelOp op, boolean fill) {
        int x = radius;
        int y = 0;
        int d = 1 - radius;
        int deltaE = 3;
        int deltaSE = 5 - 2 * radius;
        if (fill) {
            DDA.fillCirclePoints(cx, cy, x, y, op);
        } else {
            DDA.circlePoints(cx, cy, x, y, op);
        }
        int lastX = x;
        int lastY = y;
        while (x > y) {
            if (d < 0) {
                d += deltaE;
                deltaSE += 2;
            } else {
                d += deltaSE;
                deltaSE += 4;
                --x;
            }
            deltaE += 2;
            if (x != lastY || ++y != lastX) {
                if (fill) {
                    DDA.fillCirclePoints(cx, cy, x, y, op);
                } else {
                    DDA.circlePoints(cx, cy, x, y, op);
                }
            }
            lastX = x;
            lastY = y;
        }
    }

    private static void ellipsePoints(int cx, int cy, int x, int y, PixelOp op) {
        op.apply(cx + x, cy + y);
        op.apply(cx - x, cy + y);
        op.apply(cx + x, cy - y);
        op.apply(cx - x, cy - y);
    }

    private static void fillEllipsePointsH(int cx, int cy, int x, int y, PixelOp op) {
        DDA.horizontalLine(cx - x, cx + x, cy - y, op);
        DDA.horizontalLine(cx - x, cx + x, cy + y, op);
    }

    private static void fillEllipsePointsV(int cx, int cy, int x, int y, PixelOp op) {
    }

    public static void drawEllipse(int cx, int cy, int a, int b, PixelOp op, boolean fill) {
        int a2 = a * a;
        int b2 = b * b;
        int y = b;
        int d = 2 * b2 + a2 * (1 - 2 * b);
        int x = 0;
        while (b2 * x <= a2 * y) {
            if (fill) {
                DDA.fillEllipsePointsH(cx, cy, x, y, op);
            } else {
                DDA.ellipsePoints(cx, cy, x, y, op);
            }
            if (d >= 0) {
                d += 4 * a2 * (1 - y--);
            }
            d += b2 * (4 * x + 6);
            ++x;
        }
        x = a;
        d = 2 * a2 + b2 * (1 - 2 * a);
        y = 0;
        while (a2 * y <= b2 * x) {
            if (fill) {
                DDA.fillEllipsePointsH(cx, cy, x, y, op);
            } else {
                DDA.ellipsePoints(cx, cy, x, y, op);
            }
            if (d >= 0) {
                d += 4 * b2 * (1 - x--);
            }
            d += a2 * (4 * y + 6);
            ++y;
        }
    }
}

