/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.EdgeFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EdgeFilterCustomizer
extends PreviewFilterCustomizer
implements ItemListener {
    private JComboBox vChoice;
    private JComboBox hChoice;
    private EdgeFilter filter;
    public static final float[] NULL = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static float[][] hMatrix = new float[][]{NULL, EdgeFilter.ROBERTS_H, EdgeFilter.PREWITT_H, EdgeFilter.SOBEL_H, EdgeFilter.FREI_CHEN_H};
    private static float[][] vMatrix = new float[][]{NULL, EdgeFilter.ROBERTS_V, EdgeFilter.PREWITT_V, EdgeFilter.SOBEL_V, EdgeFilter.FREI_CHEN_V};

    public EdgeFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        SuperGridLayout sgl = new SuperGridLayout(3, 2);
        p.setLayout(sgl);
        sgl.setColWeight(0, 1);
        p.add(new JLabel("Horizontal:", 4));
        this.hChoice = this.makeMatrixCombo();
        p.add(this.hChoice);
        p.add(new JLabel("Vertical:", 4));
        this.vChoice = this.makeMatrixCombo();
        p.add(this.vChoice);
    }

    private JComboBox makeMatrixCombo() {
        JComboBox<String> c = new JComboBox<String>();
        c.addItemListener(this);
        c.addItem("None");
        c.addItem("Roberts");
        c.addItem("Prewitt");
        c.addItem("Sobel");
        c.addItem("Frei-Chen");
        return c;
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (EdgeFilter)o;
        this.setComboItem(this.hChoice, (Object[])hMatrix, this.filter.getHEdgeMatrix());
        this.setComboItem(this.vChoice, (Object[])vMatrix, this.filter.getVEdgeMatrix());
    }

    private void setComboItem(JComboBox cb, Object[] array, Object o) {
        for (int i = 0; i < array.length; ++i) {
            if (o != array[i]) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (this.filter != null) {
            if (source == this.hChoice) {
                this.filter.setHEdgeMatrix(hMatrix[Math.max(0, this.hChoice.getSelectedIndex())]);
            } else if (source == this.vChoice) {
                this.filter.setVEdgeMatrix(vMatrix[Math.max(0, this.vChoice.getSelectedIndex())]);
            }
            this.preview();
        }
    }
}

