/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class FlipTransition
extends AbstractBufferedImageOp {
    private float transition = 0.0f;
    private float angle = 0.0f;
    private BufferedImage destination;

    public void setTransition(float transition) {
        this.transition = transition;
    }

    public float getTransition() {
        return this.transition;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setDestination(BufferedImage destination) {
        this.destination = destination;
    }

    public BufferedImage getDestination() {
        return this.destination;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        if (this.destination == null) {
            return dst;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        Graphics2D g = dst.createGraphics();
        int w = Math.abs((int)(Math.cos((double)this.transition * Math.PI) * (double)width));
        g.drawImage(this.transition > 0.5f ? this.destination : src, (width - w) / 2, 0, w, height, null);
        g.dispose();
        return dst;
    }

    public String toString() {
        return "Transitions/Flip...";
    }
}

