/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.util.Memento;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageMemento
implements Memento {
    private BufferedImage image;
    private BufferedImage savedBit;
    private int x;
    private int y;
    private int w;
    private int h;

    public ImageMemento(BufferedImage image, int x, int y, int w, int h) {
        this.image = image;
        if (x < 0) {
            w += x;
            x = 0;
        } else if (x >= image.getWidth()) {
            x = image.getWidth();
            w = 0;
        }
        if (x + w > image.getWidth()) {
            w = image.getWidth() - x;
        }
        if (y < 0) {
            h += y;
            y = 0;
        } else if (y >= image.getHeight()) {
            y = image.getHeight();
            h = 0;
        }
        if (y + h > image.getHeight()) {
            h = image.getHeight() - y;
        }
        if (w != 0 && h != 0) {
            this.savedBit = new BufferedImage(w, h, image.getType());
            Graphics2D g = (Graphics2D)this.savedBit.getGraphics();
            g.setComposite(AlphaComposite.getInstance(2));
            g.drawImage(image, null, -x, -y);
            g.dispose();
        }
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void restore() {
        if (this.w != 0 && this.h != 0) {
            BufferedImage t = new BufferedImage(this.w, this.h, this.image.getType());
            Graphics2D g = (Graphics2D)t.getGraphics();
            g.setComposite(AlphaComposite.getInstance(2));
            g.drawImage(this.image, null, -this.x, -this.y);
            g.dispose();
            g = (Graphics2D)this.image.getGraphics();
            g.setComposite(AlphaComposite.getInstance(2));
            g.drawImage(this.savedBit, null, this.x, this.y);
            g.dispose();
            this.savedBit = t;
        }
    }
}

