/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImageServlet
extends HttpServlet {
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Image;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("image/png");
        String filterName = request.getParameter("filter");
        String imageURL = request.getParameter("image");
        BufferedImage image = null;
        BufferedImageOp filter = null;
        if (imageURL != null) {
            image = ImageIO.read(new URL(imageURL));
        }
        if (image == null) {
            image = new BufferedImage(256, 256, 2);
            Graphics2D g = image.createGraphics();
            g.setColor(Color.blue);
            g.fillOval(0, 0, 256, 256);
            g.setColor(Color.red);
            g.fillOval(10, 10, 100, 100);
            g.dispose();
        }
        if (filterName != null) {
            filterName = "com.jhlabs.image." + filterName + "Filter";
            try {
                filter = (BufferedImageOp)Class.forName(filterName).newInstance();
                if (filter != null) {
                    BeanInfo info = null;
                    Enumeration e = request.getParameterNames();
                    while (e.hasMoreElements()) {
                        String s = (String)e.nextElement();
                        if (s.equals("image") || s.equals("filter")) continue;
                        try {
                            if (info == null) {
                                info = Introspector.getBeanInfo(filter.getClass());
                            }
                            PropertyDescriptor[] pds = info.getPropertyDescriptors();
                            boolean found = false;
                            for (int j = 0; j < pds.length; ++j) {
                                PropertyDescriptor pd = pds[j];
                                if (!pd.getName().equals(s)) continue;
                                found = true;
                                Method method = pd.getWriteMethod();
                                try {
                                    String v = request.getParameter(s);
                                    Class<?> type = pd.getPropertyType();
                                    Object value = null;
                                    if (type.equals(class$java$lang$Float == null ? ImageServlet.class$("java.lang.Float") : class$java$lang$Float)) {
                                        value = Float.valueOf(v);
                                    } else if (type.equals(class$java$lang$Integer == null ? ImageServlet.class$("java.lang.Integer") : class$java$lang$Integer)) {
                                        value = Integer.valueOf(v);
                                    } else if (type.equals(class$java$lang$Boolean == null ? ImageServlet.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                                        value = Boolean.valueOf(v);
                                    } else if (type.equals(class$java$lang$String == null ? ImageServlet.class$("java.lang.String") : class$java$lang$String)) {
                                        value = v;
                                    } else if (type.equals(class$java$awt$Image == null ? ImageServlet.class$("java.awt.Image") : class$java$awt$Image)) {
                                        value = ImageIO.read(new URL(v));
                                    }
                                    if (value == null) break;
                                    method.invoke((Object)filter, value);
                                }
                                catch (Exception ex) {
                                    System.out.println("Error setting value for property: " + s);
                                    ex.printStackTrace();
                                }
                                break;
                            }
                            if (found) continue;
                            System.out.println("No such property in object: " + s);
                        }
                        catch (IntrospectionException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (filter != null) {
            image = filter.filter(image, null);
        }
        ServletOutputStream sos = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "png", sos);
        sos.close();
    }
}

