/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class PaintingContext {
    public static final String FGCOLOR_PROPERTY = "fgColor";
    public static final String BGCOLOR_PROPERTY = "bgColor";
    public static final String STROKE_PROPERTY = "stroke";
    public static final String PAINT_PROPERTY = "paint";
    public static final String COLORMAP_PROPERTY = "colormap";
    public static final String COMPOSITE_PROPERTY = "composite";
    public static final String LIGHT_DIRECTION_PROPERTY = "lightDirection";
    public static final String PAINT_MODE_PROPERTY = "paintMode";
    public static final int STROKE = 0;
    public static final int FILL = 1;
    public static final int FILL_AND_STROKE = 2;
    public static final int SELECT = 3;
    public static final int ADD_SELECT = 4;
    public static final int SUBTRACT_SELECT = 5;
    private int fgColor = -16777216;
    private int bgColor = -1;
    private Stroke stroke = new BasicStroke(1.0f);
    private Composite composite;
    private Paint paint;
    private Colormap colormap;
    private double lightDirection;
    private float lineWidth = 1.0f;
    private int paintMode = 0;
    private static PaintingContext instance;
    protected transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public static PaintingContext getInstance() {
        if (instance == null) {
            instance = new PaintingContext();
        }
        return instance;
    }

    public int getPaintColor(MouseEvent e) {
        return e.isControlDown() ? this.getBgColor() : this.getFgColor();
    }

    public void setFgColor(int c) {
        if (this.fgColor != c) {
            this.fgColor = c;
            this.changeSupport.firePropertyChange(FGCOLOR_PROPERTY, null, new Color(this.fgColor));
        }
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public void setBgColor(int c) {
        if (this.bgColor != c) {
            this.bgColor = c;
            this.changeSupport.firePropertyChange(BGCOLOR_PROPERTY, null, new Color(this.bgColor));
        }
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setComposite(Composite composite) {
        if (composite != this.composite) {
            this.composite = composite;
            this.changeSupport.firePropertyChange(COMPOSITE_PROPERTY, null, composite);
        }
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setStroke(Stroke stroke) {
        if (stroke != this.stroke) {
            this.stroke = stroke;
            this.changeSupport.firePropertyChange(STROKE_PROPERTY, null, stroke);
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setLineWidth(float lineWidth) {
        if (lineWidth != this.lineWidth) {
            this.lineWidth = lineWidth;
            this.setStroke(new BasicStroke(lineWidth));
        }
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setPaint(Paint paint) {
        if (paint != this.paint) {
            this.paint = paint;
            this.changeSupport.firePropertyChange(PAINT_PROPERTY, null, paint);
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setColormap(Colormap colormap) {
        if (colormap != this.colormap) {
            this.colormap = colormap;
            this.changeSupport.firePropertyChange(COLORMAP_PROPERTY, null, colormap);
        }
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setPaintingMode(int paintMode) {
        if (this.paintMode != paintMode) {
            this.paintMode = paintMode;
            this.changeSupport.firePropertyChange(PAINT_MODE_PROPERTY, null, new Integer(paintMode));
        }
    }

    public int getPaintingMode() {
        return this.paintMode;
    }

    public void setLightDirection(double lightDirection) {
        this.lightDirection = lightDirection;
        this.changeSupport.firePropertyChange(LIGHT_DIRECTION_PROPERTY, null, new Double(lightDirection));
    }

    public double getLightDirection() {
        return this.lightDirection;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }
}

