/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.QuantizeFilter;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class QuantizeFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener,
DocumentListener {
    private JSlider colors;
    private JCheckBox dither;
    private JCheckBox serpentine;
    private JTextField colorsText;
    private QuantizeFilter filter;

    public QuantizeFilterCustomizer() {
        JPanel p = new JPanel();
        SuperGridLayout sgl = new SuperGridLayout(4, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        this.add((Component)p, "Center");
        p.add(new JLabel("Colors:", 4));
        this.colorsText = new JTextField(5);
        p.add(this.colorsText);
        this.colorsText.getDocument().addDocumentListener(this);
        this.dither = new JCheckBox("Dither");
        p.add(this.dither);
        this.dither.addChangeListener(this);
        this.serpentine = new JCheckBox("Serpentine");
        p.add(this.serpentine);
        this.serpentine.addChangeListener(this);
    }

    public void setObject(Object o) {
        super.setObject(o);
        QuantizeFilter filter = (QuantizeFilter)o;
        this.filter = null;
        this.serpentine.setSelected(filter.getSerpentine());
        this.colorsText.setText(Integer.toString(filter.getNumColors()));
        this.dither.setSelected(filter.getDither());
        this.filter = filter;
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.filter != null) {
            if (source == this.serpentine) {
                this.filter.setSerpentine(this.serpentine.isSelected());
            } else if (source == this.dither) {
                this.filter.setDither(this.dither.isSelected());
            }
            this.preview();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void textValueChanged(DocumentEvent event) {
        if (this.filter != null) {
            try {
                this.filter.setNumColors(Integer.parseInt(this.colorsText.getText()));
                this.preview();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

