/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.Colormap;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.QuiltFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuiltFilterCustomizer
extends PreviewFilterCustomizer
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    private JSlider iterations;
    private JSlider a;
    private JSlider b;
    private JSlider c;
    private JSlider d;
    private JSlider k;
    private JCheckBox useColormap;
    private JButton randomizeButton;
    private Colormap colormap;
    private QuiltFilter filter;

    public QuiltFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "South");
        SuperGridLayout sgl = new SuperGridLayout(3, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        p.add(new JLabel("Iterations:", 4));
        this.iterations = new JSlider(0, 0, 100000, 1);
        p.add(this.iterations);
        this.iterations.setPaintTicks(true);
        this.iterations.setMajorTickSpacing(50000);
        this.iterations.setPaintLabels(true);
        this.iterations.addChangeListener(this);
        p.add(new JLabel("A:", 4));
        this.a = new JSlider(0, -100, 100, 0);
        p.add(this.a);
        this.a.setPaintTicks(true);
        this.a.setMajorTickSpacing(100);
        this.a.addChangeListener(this);
        p.add(new JLabel("B:", 4));
        this.b = new JSlider(0, -100, 100, 0);
        p.add(this.b);
        this.b.setPaintTicks(true);
        this.b.setMajorTickSpacing(100);
        this.b.addChangeListener(this);
        p.add(new JLabel("C:", 4));
        this.c = new JSlider(0, -100, 100, 0);
        p.add(this.c);
        this.c.setPaintTicks(true);
        this.c.setMajorTickSpacing(100);
        this.c.addChangeListener(this);
        p.add(new JLabel("D:", 4));
        this.d = new JSlider(0, -100, 100, 0);
        p.add(this.d);
        this.d.setPaintTicks(true);
        this.d.setMajorTickSpacing(100);
        this.d.addChangeListener(this);
        p.add(new JLabel("K:", 4));
        this.k = new JSlider(0, -10, 10, 0);
        p.add(this.k);
        this.k.setPaintTicks(true);
        this.k.setMajorTickSpacing(10);
        this.k.addChangeListener(this);
        this.randomizeButton = new JButton("Randomize");
        p.add(this.randomizeButton);
        this.randomizeButton.addActionListener(this);
        this.useColormap = new JCheckBox("Use Colormap");
        p.add(this.useColormap);
        this.useColormap.addChangeListener(this);
        this.add(p);
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (QuiltFilter)o;
        this.iterations.setValue(this.filter.getIterations());
        this.a.setValue((int)((double)this.filter.getA() * 100.0));
        this.b.setValue((int)((double)this.filter.getB() * 100.0));
        this.c.setValue((int)((double)this.filter.getC() * 100.0));
        this.d.setValue((int)((double)this.filter.getD() * 100.0));
        this.k.setValue(this.filter.getK());
        this.colormap = this.filter.getColormap();
        this.useColormap.setSelected(this.colormap != null);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.iterations) {
                this.filter.setIterations(this.iterations.getValue());
            } else if (source == this.a) {
                this.filter.setB((float)this.b.getValue() / 100.0f);
            } else if (source == this.b) {
                this.filter.setC((float)this.c.getValue() / 100.0f);
            } else if (source == this.c) {
                this.filter.setC((float)this.c.getValue() / 100.0f);
            } else if (source == this.d) {
                this.filter.setD((float)this.d.getValue() / 100.0f);
            } else if (source == this.k) {
                this.filter.setK(this.k.getValue());
            } else if (source == this.useColormap) {
                this.filter.setColormap(this.useColormap.isSelected() ? this.colormap : null);
            }
            this.preview();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source;
        if (this.filter != null && (source = e.getSource()) == this.randomizeButton) {
            this.filter.randomize();
            this.setObject(this.filter);
            this.preview();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("colormap".equals(event.getPropertyName())) {
            Object source = event.getSource();
            if (this.useColormap.isSelected()) {
                this.colormap = (Colormap)event.getNewValue();
                this.filter.setColormap(this.colormap);
                this.preview();
            }
        }
    }
}

