/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.RotateFilter;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RotateFilterCustomizer
extends PreviewFilterCustomizer
implements DocumentListener {
    private JTextField angleText;
    private RotateFilter filter;

    public RotateFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        p.add(new JLabel("Angle:", 4));
        this.angleText = new JTextField(8);
        p.add(this.angleText);
        this.angleText.getDocument().addDocumentListener(this);
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (RotateFilter)o;
        this.angleText.setText(Double.toString((double)this.filter.getAngle() / Math.PI * 180.0));
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void textValueChanged(DocumentEvent event) {
        if (this.filter != null) {
            try {
                Float angle = new Float(this.angleText.getText());
                this.filter.setAngle(angle.floatValue() * (float)Math.PI / 180.0f);
                this.preview();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

