/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.BlurTransition;
import com.jhlabs.image.GradientWipeFilter;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.ImageUtils;
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import javax.swing.ImageIcon;

public class TransitionApplet
extends Applet
implements Runnable {
    private BufferedImageOp filter;
    private Thread thread = null;
    private boolean running = false;
    private BufferedImage sourceImage;
    private BufferedImage destImage;
    private BufferedImage maskImage;
    private BufferedImage image;
    private float t = 0.0f;

    public void init() {
        String filterName = this.getParameter("filter");
        String sourceImageName = this.getParameter("sourceimage");
        String destImageName = this.getParameter("destimage");
        String maskImageName = this.getParameter("maskimage");
        try {
            this.filter = (BufferedImageOp)Class.forName(filterName).newInstance();
        }
        catch (Throwable e) {
            System.out.println("Error loading " + filterName + ":");
            e.printStackTrace();
        }
        this.sourceImage = ImageUtils.createImage(new ImageIcon(this.getClass().getResource(sourceImageName)).getImage().getSource());
        this.destImage = ImageUtils.createImage(new ImageIcon(this.getClass().getResource(destImageName)).getImage().getSource());
        if (maskImageName != null) {
            this.maskImage = ImageUtils.createImage(new ImageIcon(this.getClass().getResource(maskImageName)).getImage().getSource());
        }
        if (this.filter instanceof BlurTransition) {
            ((BlurTransition)this.filter).setDestination(this.destImage);
        } else {
            ((GradientWipeFilter)this.filter).setMask(this.maskImage != null ? this.maskImage : this.destImage);
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TransitionApplet.this.handleMouseClick();
            }
        });
    }

    public void stop() {
        this.stopThread();
    }

    public void startThread() {
        if (this.thread == null) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void stopThread() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.running = true;
            while (this.running) {
                this.t += 0.02f;
                if (this.filter != null) {
                    BufferedImageOp bufferedImageOp = this.filter;
                    synchronized (bufferedImageOp) {
                        if (this.filter instanceof BlurTransition) {
                            ((BlurTransition)this.filter).setTransition(ImageMath.triangle(this.t));
                        } else {
                            ((GradientWipeFilter)this.filter).setDensity(ImageMath.triangle(this.t));
                        }
                        this.image = this.filter.filter(this.sourceImage, this.image);
                        this.repaint();
                    }
                }
                Thread.sleep(40L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    private void handleMouseClick() {
        if (this.running) {
            this.stopThread();
        } else {
            this.startThread();
        }
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            if (this.filter instanceof GradientWipeFilter) {
                g.drawImage(this.destImage, 0, 0, this);
            }
            g.drawImage(this.image, 0, 0, this);
        } else {
            g.drawImage(this.sourceImage, 0, 0, this);
        }
    }
}

