/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.xml;

import org.xml.sax.AttributeList;

public class XMLUtils {
    public static String xmlEscape(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&#34;");
                continue;
            }
            if (c == '\'') {
                sb.append("&#39;");
                continue;
            }
            if (c < '\u007f') {
                sb.append(c);
                continue;
            }
            sb.append("&#" + Integer.toString(c) + ";");
        }
        return sb.toString();
    }

    public static String getStringValue(AttributeList attrs, String name, String defaultValue) {
        if (attrs != null && (name = attrs.getValue(name)) != null) {
            return name;
        }
        return defaultValue;
    }

    public static boolean getBooleanValue(AttributeList attrs, String name, boolean defaultValue) {
        String s;
        if (attrs != null && (s = attrs.getValue(name)) != null) {
            return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("yes");
        }
        return defaultValue;
    }

    public static int getIntValue(AttributeList attrs, String name, int defaultValue) {
        if (attrs != null && (name = attrs.getValue(name)) != null) {
            try {
                return Integer.parseInt(name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloatValue(AttributeList attrs, String name, float defaultValue) {
        if (attrs != null && (name = attrs.getValue(name)) != null) {
            try {
                return Float.valueOf(name).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double getDoubleValue(AttributeList attrs, String name, double defaultValue) {
        if (attrs != null && (name = attrs.getValue(name)) != null) {
            try {
                return Double.valueOf(name);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

