/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.crw;

import it.tidalwave.imageio.crw.CRWMetadata;
import it.tidalwave.imageio.rawprocessor.ColorMatrix;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.ColorConversionOperation;
import it.tidalwave.imageio.util.Logger;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class CRWColorConversionOperation
extends ColorConversionOperation {
    private static final Logger logger = CRWColorConversionOperation.getLogger(CRWColorConversionOperation.class);
    private final Map<String, ColorMatrix> matrixMapByModel = new HashMap<String, ColorMatrix>();

    public CRWColorConversionOperation() {
        this.matrixMapByModel.put("CANON EOS D30 DIGITAL", CRWColorConversionOperation.get(new int[]{9805, -2689, -1312, -5803, 13064, 3068, -2438, 3075, 8775}));
        this.matrixMapByModel.put("CANON EOS D60 DIGITAL", CRWColorConversionOperation.get(new int[]{6188, -1341, -890, -7168, 14489, 2937, -2640, 3228, 8483}));
        this.matrixMapByModel.put("CANON EOS 300D DIGITAL", CRWColorConversionOperation.get(new int[]{8197, -2000, -1118, -6714, 14335, 2592, -2536, 3178, 8266}));
    }

    private static ColorMatrix get(@Nonnull int[] values) {
        return CRWColorConversionOperation.getMatrix(values, 1.0E-4);
    }

    @CheckForNull
    protected ColorMatrix getColorMatrixXYZ(@Nonnull PipelineArtifact artifact) {
        CRWMetadata metadata = (CRWMetadata)artifact.getRAWMetadata();
        String model = metadata.getModel().toUpperCase().trim();
        return this.matrixMapByModel.get(model);
    }
}

