/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

public class Cookie
implements Cloneable {
    private String key;
    private String value;
    private String comment;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private String name;
    private String domain;
    private int version = 0;
    private static boolean[] validChar = new boolean[128];

    public Cookie(String string, String string2) {
        int n = string.length();
        for (int i = n - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c >= '\u007f' || !validChar[c]) {
                throw new IllegalArgumentException("illegal cookie name: " + string);
            }
            if (c != '$' || i != 0) continue;
            throw new IllegalArgumentException("cookie can't start with '$'");
        }
        this.name = string;
        this.value = string2;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int n) {
        this.maxAge = n;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Cookie " + this.name + "=" + this.value);
        if (this.path != null) {
            stringBuffer.append(" path=" + this.path);
        }
        if (this.domain != null) {
            stringBuffer.append(" domain=" + this.domain);
        }
        if (this.maxAge > 0) {
            stringBuffer.append(" max-age=" + this.maxAge);
        }
        if (this.secure) {
            stringBuffer.append(" secure");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        for (int i = 33; i < 127; ++i) {
            Cookie.validChar[i] = true;
        }
        Cookie.validChar[44] = false;
        Cookie.validChar[59] = false;
    }
}

