/*
 * Decompiled with CFR 0.152.
 */
package quicktime;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import quicktime.MacDoQuit;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTObjectManagement;
import quicktime.QTRuntimeException;
import quicktime.WinJNIDrawingSurface;
import quicktime.WinJNINative;
import quicktime.app.time.TaskThread;
import quicktime.jdirect.InterfaceLib;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickDraw3DLib;
import quicktime.jdirect.QuickTimeLib;
import quicktime.jdirect.QuickTimeVRLib;
import quicktime.jdirect.SoundLib;
import quicktime.qd.GDevice;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd3d.QD3DException;
import quicktime.util.QTBuild;
import quicktime.util.QTUtils;
import sun.awt.DrawingSurface;
import sun.awt.DrawingSurfaceInfo;
import sun.awt.Win32DrawingSurface;

public final class QTSession
implements QuickTimeLib,
QuickTimeVRLib,
QuickDraw3DLib {
    private static Object linkage;
    private static boolean doneVMCheck;
    private static boolean qtPresent;
    private static boolean gestaltDone;
    private static boolean vrinitialized;
    private static int initDone;
    private static boolean threeDInitialised;
    private static boolean enterCalled;
    private static int version;
    private static int osConstant;
    private static int jVersion;
    private static Class theClass;
    public static final int kMacOS = 1;
    public static final int kWin32 = 2;
    public static final int kMacOSX = 4;
    public static final int kInitVR = 1;
    public static final int kInit3D = 2;
    private static boolean firstTime;
    private static boolean qtjwiredDebug;
    private static int wPort;
    private static int hWnd;
    private static Object dispatchFrame;
    private static Object macQuitter;
    static int sessionID;
    private static final Object termLock;
    private static Vector canvases;
    static /* synthetic */ Class class$quicktime$QTSession;

    private static void doVMCheck() {
        if (!doneVMCheck) {
            String string = System.getProperty("java.version");
            int n = 0;
            while (!Character.isDigit(string.charAt(n))) {
                ++n;
            }
            int n2 = Character.getNumericValue(string.charAt(n));
            jVersion = n2 << 16;
            int n3 = 0;
            if (string.length() > n + 1) {
                ++n;
                while (string.length() > n && !Character.isDigit(string.charAt(n))) {
                    ++n;
                }
                if (string.length() > n) {
                    n3 = Character.getNumericValue(string.charAt(n));
                }
            }
            jVersion |= n3;
            if (n2 < 1 || n2 == 1 && n3 < 1) {
                throw new QTRuntimeException("QTJava requires Java Version 1.1 or greater");
            }
            String string2 = System.getProperty("java.vendor");
            String string3 = System.getProperty("os.name");
            if (QTSession.isCurrentOS(2)) {
                if (string2.startsWith("Netscape") || string2.startsWith("Microsoft")) {
                    throw new QTRuntimeException("QTJava requires Sun Java VM 1.1 or greater");
                }
            } else if (!string2.startsWith("Apple ")) {
                throw new QTRuntimeException("QTJava requires Apple Java VM 1.1 or greater");
            }
            doneVMCheck = true;
        }
    }

    private QTSession() {
    }

    public static int getJavaVersion() {
        if (jVersion == 0) {
            QTSession.doVMCheck();
        }
        return jVersion;
    }

    public static boolean isClassSigned() {
        if (theClass != null) {
            Object[] objectArray = theClass.getSigners();
            return objectArray != null;
        }
        return false;
    }

    public static boolean hasSecurityRestrictions() {
        SecurityManager securityManager = null;
        securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkExit(0);
            }
            catch (SecurityException securityException) {
                return !QTSession.isClassSigned();
            }
        }
        return false;
    }

    public static boolean canDoFullScreen() {
        if (System.getSecurityManager() != null) {
            return QTSession.isClassSigned() || System.getSecurityManager().checkTopLevelWindow(new Frame());
        }
        return true;
    }

    public static boolean isCurrentOS(int n) {
        if (osConstant <= 0) {
            if (osConstant == -1) {
                return false;
            }
            String string = System.getProperty("os.name");
            osConstant = string.regionMatches(false, 0, "Darwin", 0, 6) || string.regionMatches(false, 0, "Mac OS X", 0, 8) ? 4 : (string.regionMatches(false, 0, "Mac", 0, 3) ? 1 : (string.regionMatches(false, 0, "Win", 0, 3) ? 2 : -1));
        }
        return (n & osConstant) != 0;
    }

    public static boolean isInitialized() {
        return initDone != 0;
    }

    public static boolean isVRInitialized() {
        return vrinitialized;
    }

    public static boolean is3DInitialized() {
        return threeDInitialised;
    }

    public static void initialize(int n) throws QTException {
        QTSession.initialize(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(int n, Class clazz) throws QTException {
        QTSession.doVMCheck();
        Object object = QTSession.terminationLock();
        synchronized (object) {
            if (initDone == 0) {
                if (clazz != null) {
                    theClass = clazz;
                    if (!QTSession.isClassSigned()) {
                        throw new SecurityException(clazz + ",is NOT SIGNED");
                    }
                }
                if (QTSession.isCurrentOS(2)) {
                    short s = QTSession.InitializeQTML(n);
                    QTException.checkError(s);
                    try {
                        Class.forName("java.awt.Frame");
                        if (dispatchFrame == null) {
                            QTFrame qTFrame = new QTFrame();
                            qTFrame.setLayout(null);
                            qTFrame.pack();
                            dispatchFrame = qTFrame;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                QTObject.qtIsNOTInitialized = false;
                initDone = 1;
                ++sessionID;
                if (!firstTime) {
                    QDGraphics.scratch = new QDGraphics(QDGraphics.kDefaultPixelFormat, new QDRect(1, 1), null, GDevice.getMain(), 2);
                    QDGraphics.validScratch = new QDGraphics(QDGraphics.kDefaultPixelFormat, new QDRect(1, 1), null, GDevice.getMain(), 2);
                }
                if (QTSession.isCurrentOS(1) && macQuitter == null) {
                    macQuitter = new MacDoQuit();
                }
            } else {
                ++initDone;
            }
        }
    }

    private static void JQTinitializeVR() throws QTException {
        if (!QTSession.isCurrentOS(4) && QuickTimeVRLib.libraryInstance == null) {
            throw new UnsatisfiedLinkError("QuickTimeVRLib");
        }
        vrinitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void JQTinitialize() throws QTException {
        QTSession.doVMCheck();
        Object object = QTSession.terminationLock();
        synchronized (object) {
            if (qtjwiredDebug) {
                System.out.println("JQTinitialize...");
            }
            if (initDone == 0) {
                if (QTSession.isCurrentOS(2)) {
                    hWnd = WinJNINative.GetHWND();
                }
                int n = QTSession.gestalt(1903454573);
                qtPresent = true;
                version = n;
                if (QTSession.getMajorVersion() < 4 || QTSession.getMajorVersion() == 4 && QTSession.getMinorVersion() < 1) {
                    if (qtjwiredDebug) {
                        System.out.println("Version of QuickTime not found...");
                    }
                    QTSession.JQTterminate();
                    throw new QTException("Version of QuickTime not found");
                }
                QTObject.qtIsNOTInitialized = false;
                initDone = 1;
                ++sessionID;
                if (qtjwiredDebug) {
                    System.out.println("scratch depth 0x" + Integer.toHexString(QDGraphics.kDefaultPixelFormat));
                }
                if (!firstTime) {
                    QDGraphics.scratch = new QDGraphics(QDGraphics.kDefaultPixelFormat, new QDRect(1, 1), null, GDevice.getMain(), 2);
                    if (qtjwiredDebug) {
                        System.out.println("validScratch depth 0x" + Integer.toHexString(QDGraphics.kDefaultPixelFormat));
                    }
                    QDGraphics.validScratch = new QDGraphics(QDGraphics.kDefaultPixelFormat, new QDRect(1, 1), null, GDevice.getMain(), 2);
                }
                if (qtjwiredDebug) {
                    System.out.println("JQTinitialized");
                }
            } else {
                ++initDone;
            }
        }
    }

    public static void initializeVR() throws QTException {
        if (!QTSession.isInitialized()) {
            QTSession.initialize(0);
        }
        if (!vrinitialized) {
            QTSession.JQTinitializeVR();
            if (QTSession.isCurrentOS(2)) {
                short s = QTSession.InitializeQTVR();
                QTException.checkError(s);
            }
        }
    }

    public static void initialize3D() throws QTException {
        if (!QTSession.isInitialized()) {
            QTSession.initialize(0);
        }
        if (!threeDInitialised) {
            if (QTSession.isCurrentOS(1)) {
                QTSession.gestalt(1902392164);
            } else if (QTSession.isCurrentOS(2)) {
                if (QuickDraw3DLib.libraryInstance == null) {
                    throw new UnsatisfiedLinkError("QuickDraw3DLib");
                }
            } else {
                throw new QTRuntimeException("Unsupported OS");
            }
            int n = QTSession.Q3Initialize();
            if (n == 0) {
                throw new QD3DException(-28487);
            }
        }
        threeDInitialised = true;
    }

    public static void open() throws QTException {
        QTSession.open(3, 0, 0);
    }

    public static void open(int n) throws QTException {
        QTSession.open(3, 0, n);
    }

    public static void open(int n, int n2, int n3) throws QTException {
        QTSession.initialize(0);
        int n4 = QTSession.gestalt(1903454573);
        qtPresent = true;
        version = n4;
        if (QTSession.getMajorVersion() < n || QTSession.getMajorVersion() == n && QTSession.getMinorVersion() < n2) {
            QTSession.close();
            throw new QTException("Version of QuickTime not found");
        }
        QTSession.enterMovies();
        enterCalled = true;
        if ((1 & n3) != 0) {
            QTSession.initializeVR();
        }
        if ((2 & n3) != 0 && !QTSession.isCurrentOS(4)) {
            QTSession.initialize3D();
        }
    }

    public static void open(Class clazz) throws QTException {
        QTSession.open(3, 0, 0, clazz);
    }

    public static void open(int n, Class clazz) throws QTException {
        QTSession.open(3, 0, n, clazz);
    }

    public static void open(int n, int n2, int n3, Class clazz) throws QTException {
        QTSession.initialize(0, clazz);
        int n4 = QTSession.gestalt(1903454573);
        qtPresent = true;
        version = n4;
        if (QTSession.getMajorVersion() < n || QTSession.getMajorVersion() == n && QTSession.getMinorVersion() < n2) {
            QTSession.close();
            throw new QTException("Version of QuickTime not found");
        }
        QTSession.enterMovies();
        enterCalled = true;
        if ((1 & n3) != 0) {
            QTSession.initializeVR();
        }
        if ((2 & n3) != 0 && !QTSession.isCurrentOS(4)) {
            QTSession.initialize3D();
        }
    }

    public static void close() {
        QTSession.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        if (initDone > 1) {
            --initDone;
        } else if (initDone == 1) {
            QTSession.removeAllCanvases();
            TaskThread.killAllThreads();
            QTUtils.reclaimMemory();
            Object object = QTSession.terminationLock();
            synchronized (object) {
                QTObject.qtIsNOTInitialized = true;
                initDone = 0;
                Object object2 = QTNative.globalsLock;
                synchronized (object2) {
                    QTObjectManagement.removeAll();
                }
                QTSession.terminateVR();
                QTSession.terminate3D();
                if (enterCalled) {
                    QTSession.exitMovies();
                    enterCalled = false;
                }
                if (!firstTime) {
                    QDGraphics.scratch = null;
                    QDGraphics.validScratch = null;
                } else {
                    firstTime = false;
                }
                if (QTSession.isCurrentOS(2)) {
                    WinJNINative.DestroyPortAssociations();
                    if (dispatchFrame != null && wPort != 0) {
                        QTSession.DestroyPortAssociation(wPort);
                        wPort = 0;
                        ((Frame)dispatchFrame).dispose();
                        dispatchFrame = null;
                    }
                    QTSession.TerminateQTML();
                }
                theClass = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void JQTterminate() {
        if (initDone > 1) {
            --initDone;
        } else if (initDone == 1) {
            if (qtjwiredDebug) {
                System.out.println("Doing Terminate");
            }
            QTSession.removeAllCanvases();
            TaskThread.killAllThreads();
            QTUtils.reclaimMemory();
            Object object = QTSession.terminationLock();
            synchronized (object) {
                QTObject.qtIsNOTInitialized = true;
                initDone = 0;
                QTObjectManagement.removeAll();
                if (qtjwiredDebug) {
                    System.out.println("After RemoveAll");
                }
                if (!firstTime) {
                    QDGraphics.scratch = null;
                    QDGraphics.validScratch = null;
                } else {
                    firstTime = false;
                }
                if (QTSession.isCurrentOS(2)) {
                    WinJNINative.DestroyPortAssociations();
                    if (hWnd != 0) {
                        WinJNINative.DestroyHWnd(hWnd);
                        hWnd = 0;
                    }
                }
                theClass = null;
                vrinitialized = false;
            }
            if (qtjwiredDebug) {
                System.out.println(" JQTterminated");
            }
        }
    }

    public static Object terminationLock() {
        return termLock;
    }

    public static void terminateVR() {
        if (vrinitialized) {
            QTUtils.reclaimMemory();
            if (QTSession.isCurrentOS(2)) {
                QTSession.TerminateQTVR();
            }
            vrinitialized = false;
        }
    }

    public static void terminate3D() {
        if (threeDInitialised) {
            QTUtils.reclaimMemory();
            int n = QTSession.Q3Exit();
            threeDInitialised = false;
        }
    }

    public static boolean isQD3DAvailable() throws QTException {
        if (!QTSession.isCurrentOS(4)) {
            try {
                int n = QTSession.gestalt(1902392164);
                return n == 1;
            }
            catch (QTException qTException) {
                return false;
            }
        }
        return false;
    }

    public static boolean isQTVRAvailable() throws QTException {
        try {
            int n = QTSession.gestalt(1903457906);
            int n2 = n & 1;
            return n2 != 0;
        }
        catch (QTException qTException) {
            return false;
        }
    }

    public static final int gestalt(int n) throws QTException {
        int[] nArray = new int[]{0};
        short s = QTSession.Gestalt(n, nArray);
        QTException.checkError(s);
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void enterMovies() throws QTException {
        QTSession.doVMCheck();
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(4) && QTSession.getQTVersion() >= 0x6400000) {
                QTSession.setJavaThreadHook();
            }
            QTException.checkError(QTSession.EnterMovies());
        }
    }

    public static final void exitMovies() {
        QTSession.ExitMovies();
    }

    public static final int getMajorVersion() {
        return (version & 0xF000000) >> 24;
    }

    public static final int getMinorVersion() {
        return (version & 0xF00000) >> 20;
    }

    public static final int getBugFixVersion() {
        return (version & 0xF0000) >> 16;
    }

    public static final int getDeveloperVersion() {
        return version & 0xFFFF;
    }

    public static int getQTVersion() {
        return version;
    }

    public static int getQTMajorVersion() {
        return (version & 0xFF000000) >>> 24;
    }

    public static int getQTMinorVersion() {
        return (version & 0xFF0000) >>> 16;
    }

    static boolean isQTCanvas(Object object) {
        Class<?> clazz;
        for (clazz = object.getClass(); clazz != null && (clazz.getName().equals("quicktime.app.view.QTJavaAWTCanvas") || clazz.getName().equals("quicktime.app.view.QTJavaCocoaCanvas")); clazz = clazz.getSuperclass()) {
        }
        return clazz != null;
    }

    public static void addActiveCanvas(Object object) {
        if (!QTSession.isQTCanvas(object)) {
            return;
        }
        if (canvases.contains(object)) {
            return;
        }
        canvases.addElement(object);
    }

    public static void removeActiveCanvas(Object object) {
        canvases.removeElement(object);
    }

    private static void removeAllCanvases() {
        while (canvases.size() > 0) {
            Component component = (Component)canvases.elementAt(0);
            QTSession.removeActiveCanvas(component);
        }
    }

    static void setJavaThreadHook() {
        QTSession.SetJavaThreadCallbackProc();
    }

    private static native void DestroyPortAssociation(int var0);

    private static native int CreatePortAssociation(int var0, int var1, int var2);

    private static native short InitializeQTML(int var0);

    private static native void TerminateQTML();

    private static native short EnterMovies();

    private static native void ExitMovies();

    private static native short Gestalt(int var0, int[] var1);

    private static native short InitializeQTVR();

    private static native short TerminateQTVR();

    private static native int Q3Initialize();

    private static native int Q3Exit();

    private static native void SetJavaThreadCallbackProc();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        QTBuild.isValid();
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            Toolkit.getDefaultToolkit();
        }
        if (QTSession.isCurrentOS(2)) {
            if (QuickTimeLib.libraryInstance == null) {
                throw new UnsatisfiedLinkError("QuickTimeLib");
            }
            if (InterfaceLib.libraryInstance == null) {
                throw new UnsatisfiedLinkError("InterfaceLib");
            }
            if (PrimitivesLib.libraryInstance == null) {
                throw new UnsatisfiedLinkError("PrimitivesLib");
            }
            if (SoundLib.libraryInstance == null) {
                throw new UnsatisfiedLinkError("SoundLib");
            }
            if (System.getSecurityManager() != null) {
                if (QTSession.getJavaVersion() == 65537) {
                    if (WinJNINative.DoSecurityInit() != 0) {
                        throw new SecurityException("quicktime.QTSession");
                    }
                } else {
                    class PrivelegedAction {
                        PrivelegedAction() {
                        }

                        void establish() {
                            AccessController.doPrivileged(new PrivilegedAction(this){
                                private final /* synthetic */ PrivelegedAction this$0;
                                {
                                    this.this$0 = privelegedAction;
                                }

                                public Object run() {
                                    System.setProperty("restrict.package.definition.quicktime", "true");
                                    return null;
                                }
                            });
                        }
                    }
                    new PrivelegedAction().establish();
                }
            }
        }
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$QTSession == null ? (class$quicktime$QTSession = QTSession.class$("quicktime.QTSession")) : class$quicktime$QTSession);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        doneVMCheck = false;
        qtPresent = false;
        gestaltDone = false;
        vrinitialized = false;
        initDone = 0;
        threeDInitialised = false;
        enterCalled = false;
        osConstant = 0;
        theClass = null;
        firstTime = true;
        qtjwiredDebug = false;
        wPort = 0;
        hWnd = 0;
        termLock = new Object();
        canvases = new Vector();
    }

    static class QTFrame
    extends Frame {
        int HWND = 0;

        QTFrame() {
        }

        public void addNotify() {
            super.addNotify();
            if (QTSession.isCurrentOS(2) && QTSession.getJavaVersion() >= 65540) {
                WinJNIDrawingSurface winJNIDrawingSurface = new WinJNIDrawingSurface(this);
                winJNIDrawingSurface.lock();
                this.HWND = winJNIDrawingSurface.getHWnd();
                winJNIDrawingSurface.unlock();
                wPort = QTSession.CreatePortAssociation(this.HWND, 0, 258);
            } else if (this.getPeer() instanceof DrawingSurface) {
                DrawingSurfaceInfo drawingSurfaceInfo = ((DrawingSurface)this.getPeer()).getDrawingSurfaceInfo();
                drawingSurfaceInfo.lock();
                this.HWND = ((Win32DrawingSurface)drawingSurfaceInfo.getSurface()).getHWnd();
                drawingSurfaceInfo.unlock();
                wPort = QTSession.CreatePortAssociation(this.HWND, 0, 258);
            }
        }
    }
}

