/*
 * Decompiled with CFR 0.152.
 */
package quicktime;

import java.awt.Component;
import java.awt.Rectangle;
import quicktime.WinNativeHelper;

public class WinJNIDrawingSurface {
    private Component comp;
    private int drawingSurface = 0;

    public WinJNIDrawingSurface(Component component) {
        this.comp = component;
        this.drawingSurface = WinNativeHelper.getDrawingSurface(component);
    }

    public WinJNIDrawingSurface() {
    }

    public int lock() {
        if (this.drawingSurface == 0) {
            return 0;
        }
        return WinNativeHelper.lockDrawingSurface(this.comp, this.drawingSurface);
    }

    public void unlock() {
        if (this.drawingSurface == 0) {
            return;
        }
        WinNativeHelper.unlockDrawingSurface(this.comp, this.drawingSurface);
    }

    public Rectangle getBounds() {
        int[] nArray = new int[4];
        WinNativeHelper.getBounds(this.comp, this.drawingSurface, nArray);
        Rectangle rectangle = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        return rectangle;
    }

    public int getHWnd() {
        if (this.drawingSurface == 0) {
            return 0;
        }
        return WinNativeHelper.getDrawingSurfaceHWnd(this.comp, this.drawingSurface);
    }
}

