/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.actions;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.Actionable;
import quicktime.app.actions.TransformMatrix;
import quicktime.app.display.QTDisplaySpace;
import quicktime.app.event.DragAdapter;
import quicktime.app.event.QTMouseEvent;
import quicktime.app.image.Transformable;

public class DragAction
extends DragAdapter {
    private Actionable actor;
    private TransformMatrix transformer;

    public DragAction(TransformMatrix transformMatrix) {
        this.transformer = transformMatrix;
    }

    public Actionable getActionable() {
        return this.actor;
    }

    public void setActionable(Actionable actionable) {
        this.actor = actionable;
    }

    public void setTransformer(TransformMatrix transformMatrix) {
        this.transformer = transformMatrix;
    }

    public TransformMatrix getTransformer() {
        return this.transformer;
    }

    public void mousePressed(QTMouseEvent qTMouseEvent) {
        try {
            this.transformer.initialize((QTDisplaySpace)qTMouseEvent.getSource(), (Transformable)qTMouseEvent.getTarget(), qTMouseEvent.getX(), qTMouseEvent.getY());
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mousePressed");
        }
    }

    public void mouseDragged(QTMouseEvent qTMouseEvent) {
        try {
            if (this.transformer.transformTarget(qTMouseEvent.getX(), qTMouseEvent.getY()) && this.actor != null) {
                this.actor.trigger();
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mouseDragged");
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

