/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.actions;

import java.awt.event.MouseEvent;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.Actionable;
import quicktime.app.actions.MouseResponder;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.Transformable;
import quicktime.qd.QDDimension;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.std.image.Matrix;

public class Dragger
extends MouseResponder {
    public static final int kConstrainNone = 0;
    public static final int kConstrainLeft = 1;
    public static final int kConstrainRight = 16;
    public static final int kConstrainTop = 256;
    public static final int kConstrainBottom = 4096;
    public static final int kConstrainHorizontal = 17;
    public static final int kConstrainVertical = 4352;
    public static final int kConstrainAll = 4369;
    private int constrained = 4369;
    protected Actionable actor;
    protected Transformable target;
    protected QTDrawable space;
    protected int xBufferIfUnConstrained = 1;
    protected int yBufferIfUnConstrained = 1;
    private QDPoint[] origPt;
    private QDPoint[] lastPt;
    private QDRect spaceRect;
    private Matrix invSpaceMatrix;
    private Matrix origTargetMatrix;

    public Dragger(int n) {
        this(n, -5, 0);
    }

    public Dragger(int n, int n2) {
        this(n, n2, 0);
    }

    public Dragger(int n, int n2, int n3) {
        super(n, n2, 6 | n3);
    }

    protected void setTargetSpace(Object object) {
        this.space = (QTDrawable)object;
    }

    public void setActionable(Actionable actionable) {
        this.actor = actionable;
    }

    public Actionable getActionable() {
        return this.actor;
    }

    public boolean isAppropriate(Object object) {
        return object instanceof Transformable;
    }

    protected void setTarget(Object object) {
        this.target = (Transformable)object;
    }

    protected void removeTarget() {
        this.target = null;
    }

    public void setConstrained(int n) {
        this.constrained = n;
    }

    public int getConstrained() {
        return this.constrained;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            QDRect qDRect = this.space.getDisplayBounds();
            this.invSpaceMatrix = new Matrix();
            Matrix matrix = this.space.getMatrix().copy();
            matrix.setTx(0.0f);
            matrix.setTy(0.0f);
            matrix.inverse(this.invSpaceMatrix);
            this.origPt = new QDPoint[1];
            this.origPt[0] = new QDPoint(mouseEvent.getX(), mouseEvent.getY());
            this.invSpaceMatrix.transformPoints(this.origPt);
            this.origTargetMatrix = this.target.getMatrix();
            this.spaceRect = qDRect.copy();
            this.spaceRect.setX(0);
            this.spaceRect.setY(0);
            this.invSpaceMatrix.transformRect(this.spaceRect);
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mousePressed");
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            boolean bl = false;
            QDPoint[] qDPointArray = new QDPoint[]{new QDPoint(mouseEvent.getX(), mouseEvent.getY())};
            this.invSpaceMatrix.transformPoints(qDPointArray);
            int n = qDPointArray[0].getX() - this.origPt[0].getX();
            int n2 = qDPointArray[0].getY() - this.origPt[0].getY();
            Matrix matrix = this.origTargetMatrix.copy();
            matrix.translate(n, n2);
            QDDimension qDDimension = this.target.getOriginalSize();
            int n3 = qDDimension.getWidth();
            int n4 = qDDimension.getHeight();
            float f = matrix.getTx();
            float f2 = matrix.getTy();
            int n5 = this.spaceRect.getX();
            int n6 = this.spaceRect.getWidth() - n3;
            int n7 = this.spaceRect.getY();
            int n8 = this.spaceRect.getHeight() - n4;
            short s = matrix.getType();
            switch (s) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    QDRect qDRect = new QDRect(0, 0, n3, n4);
                    matrix.transformRect(qDRect);
                    n3 = qDRect.getWidth();
                    n4 = qDRect.getHeight();
                    n5 = (int)(matrix.getTx() - (float)qDRect.getX() + 0.5f);
                    f -= (float)n5;
                    n7 = (int)(matrix.getTy() - (float)qDRect.getY() + 0.5f);
                    f2 -= (float)n7;
                    n8 = this.spaceRect.getHeight() - n4 + n7;
                    n6 = this.spaceRect.getWidth() - n3 + n5;
                }
            }
            if (f < (float)this.spaceRect.getX()) {
                if ((this.constrained & 1) != 0) {
                    matrix.setTx(n5);
                    bl = true;
                } else if (f <= (float)(-n3)) {
                    matrix.setTx(-n3 + this.xBufferIfUnConstrained + n5);
                    bl = true;
                }
            } else if (f + (float)n3 > (float)this.spaceRect.getWidth()) {
                if ((this.constrained & 0x10) != 0) {
                    matrix.setTx(n6);
                    bl = true;
                } else if (f >= (float)this.spaceRect.getWidth()) {
                    matrix.setTx(n6 + n3 - this.xBufferIfUnConstrained);
                    bl = true;
                }
            }
            if (f2 < (float)this.spaceRect.getY()) {
                if ((this.constrained & 0x100) != 0) {
                    matrix.setTy(n7);
                    bl = true;
                } else if (f2 <= (float)(-n4)) {
                    matrix.setTy(-n4 + this.yBufferIfUnConstrained + n7);
                    bl = true;
                }
            } else if (f2 + (float)n4 > (float)this.spaceRect.getHeight()) {
                if ((this.constrained & 0x1000) != 0) {
                    matrix.setTy(n8);
                    bl = true;
                } else if (f2 >= (float)this.spaceRect.getHeight()) {
                    matrix.setTy(n8 + n4 - this.yBufferIfUnConstrained);
                    bl = true;
                }
            }
            this.target.setMatrix(matrix);
            if (bl && this.actor != null) {
                this.actor.trigger();
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mouseDragged");
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

