/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.actions;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.TickleNode;
import quicktime.app.spaces.CollectionController;
import quicktime.app.spaces.Space;
import quicktime.app.spaces.TicklishController;
import quicktime.app.time.Ticklish;

public class TickleList
implements TicklishController,
CollectionController {
    protected TickleNode list;
    private boolean wholespace = false;

    public void addedToSpace(Space space) {
    }

    public void removedFromSpace() {
    }

    public synchronized void timeChanged(int n) throws QTException {
        TickleNode tickleNode = this.list;
        while (tickleNode != null) {
            if (tickleNode.active) {
                tickleNode.action.timeChanged(n);
            }
            tickleNode = tickleNode.next;
        }
    }

    public synchronized boolean tickle(float f, int n) throws QTException {
        TickleNode tickleNode = this.list;
        while (tickleNode != null) {
            if (tickleNode.active && !tickleNode.action.tickle(f, n)) {
                tickleNode.active = false;
            }
            tickleNode = tickleNode.next;
        }
        return this.list != null;
    }

    public Enumeration members() {
        return new ListEnumerator(this.list);
    }

    public boolean isEmpty() {
        return this.list == null;
    }

    public int size() {
        int n = 0;
        TickleNode tickleNode = this.list;
        while (tickleNode != null) {
            ++n;
            tickleNode = tickleNode.next;
        }
        return n;
    }

    public synchronized boolean addMember(Object object) throws QTException {
        if (!this.isAppropriate(object)) {
            return false;
        }
        if (this.hasMember(object)) {
            return true;
        }
        Ticklish ticklish = (Ticklish)object;
        if (this.list == null) {
            this.list = this.makeTickleNode(ticklish);
        } else {
            TickleNode tickleNode = this.list;
            TickleNode tickleNode2 = tickleNode.next;
            while (tickleNode2 != null) {
                tickleNode = tickleNode2;
                tickleNode2 = tickleNode2.next;
            }
            tickleNode.next = this.makeTickleNode(ticklish);
        }
        return true;
    }

    protected TickleNode makeTickleNode(Ticklish ticklish) {
        return new TickleNode(ticklish);
    }

    public void setMemberActive(Ticklish ticklish, boolean bl) {
        TickleNode tickleNode = this._findNode(ticklish);
        if (tickleNode != null) {
            tickleNode.active = bl;
        }
    }

    public boolean isMemberActive(Ticklish ticklish) {
        TickleNode tickleNode = this._findNode(ticklish);
        if (tickleNode != null) {
            return tickleNode.active;
        }
        return false;
    }

    public boolean hasMember(Object object) {
        return this._findNode(object) != null;
    }

    public TickleNode findNode(Object object) {
        return this._findNode(object);
    }

    public Enumeration nodes() {
        return new NodeEnumerator(this.list);
    }

    private synchronized TickleNode _findNode(Object object) {
        TickleNode tickleNode = this.list;
        while (tickleNode != null) {
            if (tickleNode.action.equals(object)) {
                return tickleNode;
            }
            tickleNode = tickleNode.next;
        }
        return null;
    }

    public synchronized void removeMember(Object object) {
        if (this.list == null) {
            return;
        }
        if (this.list.action.equals(object)) {
            this.list = this.list.next;
            return;
        }
        TickleNode tickleNode = this.list;
        TickleNode tickleNode2 = tickleNode.next;
        while (tickleNode2 != null) {
            if (tickleNode2.action.equals(object)) {
                tickleNode.next = tickleNode2.next;
                break;
            }
            tickleNode2 = tickleNode2.next;
            tickleNode = tickleNode.next;
        }
    }

    public boolean isAppropriate(Object object) {
        return object instanceof Ticklish;
    }

    public boolean isWholespace() {
        return this.wholespace;
    }

    public void setWholespace(boolean bl) {
        this.wholespace = bl;
    }

    public String toString() {
        String string = this.getClass().getName() + "[";
        Enumeration enumeration = this.members();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement() + ",";
        }
        string = string + "]";
        return string;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }

    static class NodeEnumerator
    implements Enumeration {
        private TickleNode current;

        private NodeEnumerator(TickleNode tickleNode) {
            this.current = tickleNode;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException("TickleList");
            }
            TickleNode tickleNode = this.current;
            this.current = this.current.next;
            return tickleNode;
        }
    }

    static class ListEnumerator
    implements Enumeration {
        private TickleNode current;

        private ListEnumerator(TickleNode tickleNode) {
            this.current = tickleNode;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException("TickleList");
            }
            TickleNode tickleNode = this.current;
            this.current = this.current.next;
            return tickleNode.action;
        }
    }
}

