/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.event;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.anim.SWCompositor;
import quicktime.app.display.GroupDrawable;
import quicktime.app.display.QTDisplaySpace;
import quicktime.app.event.EventDispatcher;
import quicktime.app.event.MouseButtonListener;
import quicktime.app.event.MouseEnterExitListener;
import quicktime.app.event.MouseMoveListener;
import quicktime.app.event.QTEventCaster;
import quicktime.app.event.QTMouseEvent;
import quicktime.app.event.QTMouseListener;
import quicktime.app.spaces.ListenerController;
import quicktime.app.spaces.Space;
import quicktime.qd.QDRect;

public class QTMouseController
implements ListenerController {
    private Object listenerSource;
    private boolean isWithinItsSpace = false;
    private boolean isInEnclosingSpace = false;
    SWCompositor compSpace;
    QTDisplaySpace displaySpace;
    GroupDrawable drawSpace;
    EventDispatcher handler;
    MouseButtonListener mouseButtonListener;
    MouseEnterExitListener mouseEnterExitListener;
    MouseMoveListener mouseMoveListener;
    protected Space space;

    public Space getSpace() {
        return this.space;
    }

    public void addedToSpace(Space space) {
        this.space = space;
        if (this.space instanceof SWCompositor) {
            this.compSpace = (SWCompositor)this.space;
        } else if (this.space instanceof GroupDrawable) {
            this.drawSpace = (GroupDrawable)this.space;
        }
        if (this.space instanceof QTDisplaySpace) {
            this.displaySpace = (QTDisplaySpace)this.space;
        }
        if (this.listenerSource != null && this.handler == null) {
            this.addHandler();
        }
    }

    public void removedFromSpace() {
        this.space = null;
        this.compSpace = null;
        this.displaySpace = null;
        this.drawSpace = null;
        if (this.listenerSource != null && this.handler != null) {
            this.removeActiveHandler();
        }
    }

    public void addedTo(Object object) {
        this.listenerSource = object;
        if (this.handler == null) {
            this.addHandler();
        }
    }

    public void removedFrom(Object object) {
        this.listenerSource = null;
        if (this.handler != null) {
            this.removeActiveHandler();
        }
    }

    protected void addHandler() {
        this.handler = EventDispatcher.makeDispatcher(this, this.getSpace(), this.listenerSource);
        if (this.handler != null) {
            this.handler.addedTo();
            if (this.hasMouseButtonListener()) {
                this.handler.addMouseButtonListener();
            }
            if (this.hasMouseMoveListener()) {
                this.handler.addMouseMoveListener();
            }
            if (this.hasMouseEnterExitListener()) {
                this.handler.addMouseEnterExitListener();
            }
        }
    }

    protected void removeActiveHandler() {
        this.handler.removedFrom();
        this.handler = null;
    }

    protected boolean translateAndIsWithin(QTMouseEvent qTMouseEvent) {
        if (this.displaySpace != null) {
            try {
                QDRect qDRect = this.displaySpace.getDisplayBounds();
                int n = qDRect.getX();
                int n2 = qDRect.getY();
                if (this.compSpace != null) {
                    int n3 = n;
                    int n4 = n2;
                    SWCompositor sWCompositor = this.compSpace.getParent();
                    while (sWCompositor != null) {
                        SWCompositor sWCompositor2 = sWCompositor;
                        QDRect qDRect2 = sWCompositor2.getDisplayBounds();
                        n3 += qDRect2.getX();
                        n4 += qDRect2.getY();
                        sWCompositor = sWCompositor2.getParent();
                    }
                    qTMouseEvent.translate(-n3, -n4);
                } else {
                    qTMouseEvent.translate(-n, -n2);
                }
                return qDRect.inside(qTMouseEvent.getX() + n, qTMouseEvent.getY() + n2);
            }
            catch (QTException qTException) {
                QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this.compSpace, "getDisplayBounds");
            }
        }
        return true;
    }

    public void addQTMouseListener(QTMouseListener qTMouseListener) {
        if (qTMouseListener instanceof MouseButtonListener) {
            this.addMouseButtonListener((MouseButtonListener)qTMouseListener);
        }
        if (qTMouseListener instanceof MouseMoveListener) {
            this.addMouseMoveListener((MouseMoveListener)qTMouseListener);
        }
        if (qTMouseListener instanceof MouseEnterExitListener) {
            this.addMouseEnterExitListener((MouseEnterExitListener)qTMouseListener);
        }
    }

    public void removeQTMouseListener(QTMouseListener qTMouseListener) {
        if (qTMouseListener instanceof MouseButtonListener) {
            this.removeMouseButtonListener((MouseButtonListener)qTMouseListener);
        }
        if (qTMouseListener instanceof MouseMoveListener) {
            this.removeMouseMoveListener((MouseMoveListener)qTMouseListener);
        }
        if (qTMouseListener instanceof MouseEnterExitListener) {
            this.removeMouseEnterExitListener((MouseEnterExitListener)qTMouseListener);
        }
    }

    void addMouseButtonListener(MouseButtonListener mouseButtonListener) {
        boolean bl = this.hasMouseButtonListener();
        this.mouseButtonListener = QTEventCaster.add(this.mouseButtonListener, mouseButtonListener);
        this.updateMouseButtonListener(bl);
    }

    void removeMouseButtonListener(MouseButtonListener mouseButtonListener) {
        boolean bl = this.hasMouseButtonListener();
        this.mouseButtonListener = QTEventCaster.remove(this.mouseButtonListener, mouseButtonListener);
        this.updateMouseButtonListener(bl);
    }

    void updateMouseButtonListener(boolean bl) {
        if (this.handler != null) {
            if (bl && !this.hasMouseButtonListener()) {
                this.handler.removeMouseButtonListener();
            } else if (this.hasMouseButtonListener() && !bl) {
                this.handler.addMouseButtonListener();
            }
        }
    }

    boolean hasMouseButtonListener() {
        return this.mouseButtonListener != null;
    }

    public void mouseClicked(QTMouseEvent qTMouseEvent) {
        if (this.mouseButtonListener != null && this.mouseButtonListener.matchModifierFilter(qTMouseEvent.getModifiers()) && this.translateAndIsWithin(qTMouseEvent)) {
            this.doMouseClicked(qTMouseEvent);
        }
    }

    protected void doMouseClicked(QTMouseEvent qTMouseEvent) {
        this.mouseButtonListener.mouseClicked(qTMouseEvent);
    }

    public void mousePressed(QTMouseEvent qTMouseEvent) {
        if (this.mouseButtonListener != null && this.mouseButtonListener.matchModifierFilter(qTMouseEvent.getModifiers()) && this.translateAndIsWithin(qTMouseEvent)) {
            this.doMousePressed(qTMouseEvent);
        }
    }

    protected void doMousePressed(QTMouseEvent qTMouseEvent) {
        this.mouseButtonListener.mousePressed(qTMouseEvent);
    }

    public void mouseReleased(QTMouseEvent qTMouseEvent) {
        if (this.mouseButtonListener != null && this.mouseButtonListener.matchModifierFilter(qTMouseEvent.getModifiers()) && this.translateAndIsWithin(qTMouseEvent)) {
            this.doMouseReleased(qTMouseEvent);
        }
    }

    protected void doMouseReleased(QTMouseEvent qTMouseEvent) {
        this.mouseButtonListener.mouseReleased(qTMouseEvent);
    }

    void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        boolean bl = this.hasMouseMoveListener();
        this.mouseMoveListener = QTEventCaster.add(this.mouseMoveListener, mouseMoveListener);
        this.updateMouseMoveListener(bl);
    }

    void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        boolean bl = this.hasMouseMoveListener();
        this.mouseMoveListener = QTEventCaster.remove(this.mouseMoveListener, mouseMoveListener);
        this.updateMouseMoveListener(bl);
    }

    void updateMouseMoveListener(boolean bl) {
        if (this.handler != null) {
            if (bl && !this.hasMouseMoveListener()) {
                this.handler.removeMouseMoveListener();
            } else if (this.hasMouseMoveListener() && !bl) {
                this.handler.addMouseMoveListener();
            }
        }
    }

    boolean hasMouseMoveListener() {
        return this.mouseMoveListener != null;
    }

    boolean isInterestedInMouseMoveEvents(QTMouseEvent qTMouseEvent) {
        return this.mouseMoveListener != null && this.mouseMoveListener.matchModifierFilter(qTMouseEvent.getModifiers());
    }

    public void mouseDragged(QTMouseEvent qTMouseEvent) {
        boolean bl = false;
        if (this.isInEnclosingSpace && this.mouseEnterExitListener != null && this.mouseEnterExitListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            boolean bl2 = this.isWithinItsSpace;
            this.isWithinItsSpace = this.translateAndIsWithin(qTMouseEvent);
            bl = true;
            if (bl2 && !this.isWithinItsSpace) {
                qTMouseEvent.setEventType(505);
                this.doMouseExited(qTMouseEvent);
                qTMouseEvent.setEventType(506);
            } else if (this.isWithinItsSpace && !bl2) {
                qTMouseEvent.setEventType(504);
                this.doMouseEntered(qTMouseEvent);
                qTMouseEvent.setEventType(506);
            }
        }
        if (this.isInterestedInMouseMoveEvents(qTMouseEvent)) {
            if (!bl) {
                this.translateAndIsWithin(qTMouseEvent);
            }
            this.doMouseDragged(qTMouseEvent);
        }
    }

    protected void doMouseDragged(QTMouseEvent qTMouseEvent) {
        this.mouseMoveListener.mouseDragged(qTMouseEvent);
    }

    public void mouseMoved(QTMouseEvent qTMouseEvent) {
        if (this.mouseEnterExitListener != null && this.mouseEnterExitListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            boolean bl = this.isWithinItsSpace;
            this.isWithinItsSpace = this.translateAndIsWithin(qTMouseEvent);
            if (bl && !this.isWithinItsSpace) {
                qTMouseEvent.setEventType(505);
                this.doMouseExited(qTMouseEvent);
            } else if (this.isWithinItsSpace && !bl) {
                qTMouseEvent.setEventType(504);
                this.doMouseEntered(qTMouseEvent);
            } else if (this.isInterestedInMouseMoveEvents(qTMouseEvent)) {
                this.doMouseMoved(qTMouseEvent, this.isWithinItsSpace);
            }
        } else if (this.isInterestedInMouseMoveEvents(qTMouseEvent)) {
            this.doMouseMoved(qTMouseEvent, this.translateAndIsWithin(qTMouseEvent));
        }
    }

    protected void doMouseMoved(QTMouseEvent qTMouseEvent, boolean bl) {
        if (bl) {
            this.mouseMoveListener.mouseMoved(qTMouseEvent);
        }
    }

    void addMouseEnterExitListener(MouseEnterExitListener mouseEnterExitListener) {
        boolean bl = this.hasMouseEnterExitListener();
        this.mouseEnterExitListener = QTEventCaster.add(this.mouseEnterExitListener, mouseEnterExitListener);
        this.updateMouseEnterExitListener(bl);
    }

    void removeMouseEnterExitListener(MouseEnterExitListener mouseEnterExitListener) {
        boolean bl = this.hasMouseEnterExitListener();
        this.mouseEnterExitListener = QTEventCaster.remove(this.mouseEnterExitListener, mouseEnterExitListener);
        this.updateMouseEnterExitListener(bl);
    }

    void updateMouseEnterExitListener(boolean bl) {
        if (this.handler != null) {
            if (bl && !this.hasMouseEnterExitListener()) {
                this.handler.removeMouseEnterExitListener();
            } else if (this.hasMouseEnterExitListener() && !bl) {
                this.handler.addMouseEnterExitListener();
            }
        }
    }

    boolean hasMouseEnterExitListener() {
        return this.mouseEnterExitListener != null;
    }

    public void mouseEntered(QTMouseEvent qTMouseEvent) {
        if (this.mouseEnterExitListener != null && this.mouseEnterExitListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            this.isWithinItsSpace = this.translateAndIsWithin(qTMouseEvent);
            if (this.isWithinItsSpace) {
                this.doMouseEntered(qTMouseEvent);
            }
        }
        this.isInEnclosingSpace = true;
    }

    protected void doMouseEntered(QTMouseEvent qTMouseEvent) {
        this.mouseEnterExitListener.mouseEntered(qTMouseEvent);
    }

    public void mouseExited(QTMouseEvent qTMouseEvent) {
        this.isInEnclosingSpace = false;
        if (this.mouseEnterExitListener != null && this.mouseEnterExitListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            boolean bl = this.isWithinItsSpace;
            this.translateAndIsWithin(qTMouseEvent);
            this.isWithinItsSpace = false;
            if (bl) {
                this.doMouseExited(qTMouseEvent);
            }
        }
    }

    protected void doMouseExited(QTMouseEvent qTMouseEvent) {
        this.mouseEnterExitListener.mouseExited(qTMouseEvent);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

