/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.spaces;

import quicktime.QTRuntimeException;
import quicktime.QTSession;

public abstract class Sequencer {
    public static final int kNoLooping = 0;
    public static final int kLoopForwards = 1;
    public static final int kLoopPalindrome = 2;
    public static final int kLastFrame = -1;
    public static final int kFirstFrame = 1;
    private int looping = 0;
    private int mCurrentFrame = 1;
    private boolean forwards = true;

    public void setLooping(int n) {
        this.looping = n;
        if (this.looping == 1) {
            this.forwards = true;
        }
    }

    public int getLooping() {
        return this.looping;
    }

    public abstract int size();

    public int getCurrentFrame() {
        if (this.mCurrentFrame >= this.size()) {
            this.setCurrentFrame(this.mCurrentFrame);
        }
        return this.mCurrentFrame;
    }

    public void setCurrentFrame(int n) {
        int n2 = this.size();
        if (n == -1) {
            this.mCurrentFrame = n2;
        }
        if (n > n2) {
            if (this.mCurrentFrame == n2) {
                switch (this.looping) {
                    case 1: {
                        this.mCurrentFrame = 1;
                        break;
                    }
                    case 2: {
                        --this.mCurrentFrame;
                        this.forwards = false;
                        break;
                    }
                }
            } else {
                this.mCurrentFrame = n2;
            }
        } else if (n == 0) {
            if (this.mCurrentFrame == 1) {
                switch (this.looping) {
                    case 2: {
                        ++this.mCurrentFrame;
                        this.forwards = true;
                        break;
                    }
                    case 1: {
                        this.mCurrentFrame = n2;
                        break;
                    }
                }
            } else {
                this.mCurrentFrame = 1;
            }
        } else {
            this.mCurrentFrame = n;
        }
    }

    public void setFrameNext() {
        int n = this.looping == 2 ? (this.forwards ? this.mCurrentFrame + 1 : this.mCurrentFrame - 1) : this.mCurrentFrame + 1;
        this.setCurrentFrame(n);
    }

    public void setFramePrevious() {
        if (this.looping == 2) {
            int n;
            boolean bl = this.forwards;
            if (this.forwards) {
                n = this.mCurrentFrame - 1;
                if (n < 1) {
                    bl = false;
                }
            } else {
                n = this.mCurrentFrame + 1;
                if (n > this.size()) {
                    bl = true;
                }
            }
            this.setCurrentFrame(n);
            this.forwards = bl;
            return;
        }
        int n = this.mCurrentFrame - 1;
        this.setCurrentFrame(n);
    }

    public String toString() {
        return this.getClass().getName() + "[size=" + this.size() + "]";
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

