/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.ui;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.QTAppException;
import quicktime.app.actions.Invalidator;
import quicktime.app.anim.SWCompositor;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.image.DynamicImage;
import quicktime.app.image.ImageSpec;
import quicktime.qd.QDDimension;
import quicktime.qd.QDRect;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.Matrix;

public class UIElement
extends TwoDSprite
implements DynamicImage {
    protected ImageSpec deactiveImage;
    protected ImageSpec currentImage;
    SWCompositor c;
    Invalidator currentInvalidator;
    private boolean active = true;

    protected UIElement(ImageSpec imageSpec, ImageSpec imageSpec2, Matrix matrix, int n, GraphicsMode graphicsMode) throws QTException {
        super(matrix, n, graphicsMode);
        this.deactiveImage = imageSpec2;
        if (imageSpec == null) {
            throw new QTAppException("QTButton:released and pressed images must be specified");
        }
        this.setCurrentImage(imageSpec);
    }

    public void setLocation(int n, int n2) throws QTException {
        Matrix matrix = this.getMatrix();
        if (matrix != null) {
            matrix.setTx(n);
            matrix.setTy(n2);
            this.setMatrix(matrix);
        }
    }

    public void setSize(QDDimension qDDimension) throws QTException {
        Matrix matrix = this.getMatrix();
        float f = matrix.getTx();
        float f2 = matrix.getTy();
        if (matrix != null) {
            Matrix matrix2 = new Matrix();
            QDDimension qDDimension2 = this.getOriginalSize();
            matrix2.map(new QDRect(qDDimension2), new QDRect(qDDimension));
            matrix2.translate(f, f2);
            this.setMatrix(matrix2);
        }
    }

    public QDRect getBounds() throws QTException {
        Matrix matrix = this.getMatrix();
        QDDimension qDDimension = this.getOriginalSize();
        return new QDRect((int)matrix.getTx(), (int)matrix.getTy(), (int)(matrix.getSx() * (float)qDDimension.getWidth()), (int)(matrix.getSy() * (float)qDDimension.getHeight()));
    }

    protected void setCurrentImage(ImageSpec imageSpec) throws QTException {
        if (this.c != null && this.currentImage instanceof DynamicImage) {
            ((DynamicImage)this.currentImage).removedFromCompositor(this.c);
        }
        if (imageSpec == null) {
            this.setVisible(false);
        } else {
            this.setImageData(imageSpec.getImage(), imageSpec.getDescription());
            if (this.c != null && imageSpec instanceof DynamicImage) {
                this.currentInvalidator = ((DynamicImage)imageSpec).addedToCompositor(this.c, this);
            }
            if (this.currentImage == null) {
                this.setVisible(true);
            }
        }
        this.currentImage = imageSpec;
    }

    public void setActive(boolean bl) throws QTException {
        this.active = bl;
        if (bl) {
            this.setCurrentImage(this.currentImage);
        } else if (this.deactiveImage != null) {
            this.setCurrentImage(this.deactiveImage);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public Invalidator addedToCompositor(SWCompositor sWCompositor, TwoDSprite twoDSprite) throws QTException {
        this.c = sWCompositor;
        this.setCurrentImage(this.currentImage);
        return new UIInvalidator(this);
    }

    public void removedFromCompositor(SWCompositor sWCompositor) throws QTException {
        this.c = null;
        this.currentInvalidator = null;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }

    class UIInvalidator
    extends Invalidator {
        UIInvalidator(TwoDSprite twoDSprite) {
            super(twoDSprite);
        }

        public boolean tickle(float f, int n) throws QTException {
            if (UIElement.this.currentInvalidator != null) {
                return UIElement.this.currentInvalidator.tickle(f, n);
            }
            return true;
        }
    }
}

