/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.view;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.app.view.GraphicsImporterDrawer;
import quicktime.app.view.JQTCanvas;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTComponent;
import quicktime.app.view.QTJComponent;
import quicktime.app.view.QTJavaAWTCanvas;
import quicktime.app.view.QTJavaCocoaCanvas;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.Media;
import quicktime.std.qtcomponents.MovieImporter;
import quicktime.util.QTHandle;

public final class QTFactory {
    private static Vector classPaths;
    private static final boolean debug = false;

    public static QTComponent makeQTComponent(Movie movie) throws QTException {
        Movie movie2 = movie;
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            class PrivelegedAction {
                QTComponent comp = null;
                private final /* synthetic */ Movie val$mov;

                PrivelegedAction(Movie movie) {
                    this.val$mov = movie;
                }

                void establish() {
                    AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ PrivelegedAction this$0;
                        {
                            this.this$0 = privelegedAction;
                        }

                        public Object run() {
                            this.this$0.comp = new QTJavaCocoaCanvas(PrivelegedAction.access$000(this.this$0));
                            return this.this$0.comp;
                        }
                    });
                }

                QTComponent getComponent() {
                    return this.comp;
                }

                static /* synthetic */ Movie access$000(PrivelegedAction privelegedAction) {
                    return privelegedAction.val$mov;
                }
            }
            PrivelegedAction privelegedAction = new PrivelegedAction(movie2);
            privelegedAction.establish();
            return privelegedAction.getComponent();
        }
        return new QTJavaAWTCanvas(movie);
    }

    public static QTComponent makeQTComponent(MovieController movieController) throws QTException {
        MovieController movieController2 = movieController;
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            class PrivelegedAction {
                QTComponent comp = null;
                private final /* synthetic */ MovieController val$controller;

                PrivelegedAction(MovieController movieController) {
                    this.val$controller = movieController;
                }

                void establish() {
                    AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ PrivelegedAction this$0;
                        {
                            this.this$0 = privelegedAction;
                        }

                        public Object run() {
                            try {
                                this.this$0.comp = new QTJavaCocoaCanvas(PrivelegedAction.access$100(this.this$0));
                            }
                            catch (QTException qTException) {
                                // empty catch block
                            }
                            return this.this$0.comp;
                        }
                    });
                }

                QTComponent getComponent() {
                    return this.comp;
                }

                static /* synthetic */ MovieController access$100(PrivelegedAction privelegedAction) {
                    return privelegedAction.val$controller;
                }
            }
            PrivelegedAction privelegedAction = new PrivelegedAction(movieController2);
            privelegedAction.establish();
            return privelegedAction.getComponent();
        }
        return new QTJavaAWTCanvas(movieController2);
    }

    public static QTComponent makeQTComponent(GraphicsImporter graphicsImporter) throws QTException {
        GraphicsImporter graphicsImporter2 = graphicsImporter;
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            class PrivelegedAction {
                QTComponent comp = null;
                private final /* synthetic */ GraphicsImporter val$gi;

                PrivelegedAction(GraphicsImporter graphicsImporter) {
                    this.val$gi = graphicsImporter;
                }

                void establish() {
                    AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ PrivelegedAction this$0;
                        {
                            this.this$0 = privelegedAction;
                        }

                        public Object run() {
                            this.this$0.comp = new QTJavaCocoaCanvas(PrivelegedAction.access$200(this.this$0));
                            return this.this$0.comp;
                        }
                    });
                }

                QTComponent getComponent() {
                    return this.comp;
                }

                static /* synthetic */ GraphicsImporter access$200(PrivelegedAction privelegedAction) {
                    return privelegedAction.val$gi;
                }
            }
            PrivelegedAction privelegedAction = new PrivelegedAction(graphicsImporter2);
            privelegedAction.establish();
            return privelegedAction.getComponent();
        }
        return new QTJavaAWTCanvas(graphicsImporter);
    }

    public static QTJComponent makeQTJComponent(GraphicsImporterDrawer graphicsImporterDrawer) throws QTException {
        return new JQTCanvas(graphicsImporterDrawer);
    }

    public static QTJComponent makeQTJComponent(MoviePlayer moviePlayer) throws QTException {
        return new JQTCanvas(moviePlayer);
    }

    public static File findInSystemPaths(String string) throws IOException {
        if (classPaths == null) {
            QTFactory.buildClassPathsVector();
        }
        return QTFactory._doFISP(string, false);
    }

    public static void addDirectory(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(file + ",does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException(file + ",must be a directory");
        }
        if (classPaths == null) {
            QTFactory.buildClassPathsVector();
        }
        String string = file.getCanonicalPath();
        if ((string = string.replace('/', File.separatorChar)).charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        if (classPaths.contains(string)) {
            return;
        }
        classPaths.addElement(string);
    }

    public static void removeDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        if (classPaths == null) {
            return;
        }
        String string = file.getCanonicalPath();
        if ((string = string.replace('/', File.separatorChar)).charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        classPaths.removeElement(string);
    }

    public static File findAbsolutePath(String string) throws IOException {
        string = string.replace('/', File.separatorChar);
        if (classPaths == null) {
            QTFactory.buildClassPathsVector();
        }
        Enumeration enumeration = classPaths.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = QTFactory.returnExistingFile(string2 + string);
            if (string3 == null) continue;
            return new File(string3);
        }
        throw new FileNotFoundException(string);
    }

    private static File _doFISP(String string, boolean bl) throws IOException {
        String string2 = string;
        int n = string2.length();
        while (n > 0) {
            String string3 = (n = string2.substring(0, n).lastIndexOf(47)) == -1 || n == 0 ? string2 : string2.substring(n + 1);
            for (int i = classPaths.size() - 1; i >= 0; --i) {
                String string4 = (String)classPaths.elementAt(i);
                String string5 = QTFactory.returnExistingFile(string4 + string3);
                if (string5 == null) continue;
                return new File(string5);
            }
        }
        throw new FileNotFoundException(string);
    }

    private static void buildClassPathsVector() throws IOException {
        classPaths = new Vector(8);
        String string = System.getProperty("java.class.path");
        while (string != null) {
            int n = string.indexOf(File.pathSeparatorChar);
            String string2 = null;
            if (n == -1) {
                string2 = string;
                string = null;
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            if ((string2 = QTFactory.returnExistingFile(string2)) == null || classPaths.contains(string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1)) || string2.length() <= 0) continue;
            classPaths.addElement(string2);
        }
        String string3 = System.getProperty("user.dir");
        if ((string3 = QTFactory.returnExistingFile(string3)) != null) {
            classPaths.addElement(string3);
        }
    }

    private static String returnExistingFile(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory() && string.charAt(string.length() - 1) != File.separatorChar) {
            return string + File.separatorChar;
        }
        return file.getCanonicalPath();
    }

    private static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(n + 1);
    }

    private static QTHandle readBytesIntoHandle(InputStream inputStream) throws IOException, QTException {
        byte[] byArray = new byte[inputStream.available()];
        int n = inputStream.read(byArray);
        if (n < 0 || n != byArray.length) {
            throw new IOException("Problem in reading bytes from InputStream");
        }
        return new QTHandle(byArray);
    }

    private static GraphicsImporter openAsImage(QTFile qTFile) throws QTException {
        try {
            return new GraphicsImporter(qTFile);
        }
        catch (StdQTException stdQTException) {
            return null;
        }
    }

    private static GraphicsImporter openAsImage(DataRef dataRef) throws QTException {
        try {
            return new GraphicsImporter(dataRef);
        }
        catch (StdQTException stdQTException) {
            return null;
        }
    }

    private static GraphicsImporter importImage(DataRef dataRef) throws QTException {
        try {
            GraphicsImporter graphicsImporter = new GraphicsImporter(dataRef);
            return graphicsImporter;
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private static Movie checkIfMovie(QTFile qTFile) throws QTException {
        return QTFactory.checkMovie(Movie.fromFile(OpenMovieFile.asRead(qTFile), 0, null));
    }

    private static Movie checkIfMovie(DataRef dataRef) throws QTException {
        try {
            return QTFactory.checkMovie(Movie.fromDataRef(dataRef, 0));
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private static Movie checkMovie(Movie movie) throws QTException {
        try {
            if (movie.getTrackCount() > 1) {
                return movie;
            }
            Track track = movie.getIndTrack(1);
            Media media = Media.getTrackMedia(track);
            if (media.getSampleCount() > 1) {
                movie.setActive(true);
                return movie;
            }
            media.disposeQTObject();
            track.disposeQTObject();
            movie.disposeQTObject();
        }
        catch (QTException qTException) {
            // empty catch block
        }
        return null;
    }

    private static Movie openAsMovie(QTFile qTFile) throws QTException {
        OpenMovieFile openMovieFile = OpenMovieFile.asRead(qTFile);
        try {
            return Movie.fromFile(openMovieFile);
        }
        catch (StdQTException stdQTException) {
            return null;
        }
    }

    private static Movie openAsMovie(DataRef dataRef) throws QTException {
        try {
            return Movie.fromDataRef(dataRef, 1);
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private static Movie importMovie(QTHandle qTHandle, int n) throws QTException {
        if (n == 0) {
            throw new QTException(-2003);
        }
        try {
            MovieImporter movieImporter = new MovieImporter(n);
            Movie movie = new Movie(1);
            movie.setDefaultDataRef(new DataRef(new QTHandle()));
            movieImporter.fromHandle(qTHandle, movie, null, 0, 1);
            return movie;
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private QTFactory() {
    }
}

