/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QTStreamingLib;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.OpenCPicParams;
import quicktime.qd.QDException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.qtcomponents.ImageCompressionDialog;
import quicktime.std.sg.SequenceGrabber;
import quicktime.streaming.Presentation;
import quicktime.streaming.Stream;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandleRef;
import quicktime.util.RawEncodedImage;

public final class Pict
extends QTHandleRef
implements QuickTimeLib,
Cloneable,
QTStreamingLib {
    private static Object linkage;
    private static int kNativeSize;
    private static transient QDGraphics gw;
    private static final int[] savedPort;
    private static final int[] savedDevice;
    static /* synthetic */ Class class$quicktime$qd$Pict;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pict thumbnailFromQDGraphics(QDGraphics qDGraphics, QDRect qDRect, int n) throws QTException {
        Pict pict = new Pict(4, false);
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Pict.GetGWorld(savedPort, savedDevice);
            }
            Pict.SetGWorld(QTObject.ID(qDGraphics), 0);
            int n2 = Pict.GetGWorldPixMap(QTObject.ID(qDGraphics));
            Pict.LockPixels(n2);
            s = Pict.MakeThumbnailFromPixMap(n2, qDRect.getRect(), (short)n, QTObject.ID(pict), 0);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Pict.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        QDException.checkError(s);
        return pict;
    }

    public static Pict fromTrack(Track track, int n) throws QTException {
        int n2 = Pict.GetTrackPict(QTObject.ID(track), n);
        StdQTException.checkError(Pict.GetMoviesError());
        return new Pict(n2);
    }

    public static Pict fromMovie(Movie movie, int n) throws QTException {
        int n2 = Pict.GetMoviePict(QTObject.ID(movie), n);
        StdQTException.checkError(Pict.GetMoviesError());
        return new Pict(n2);
    }

    public static Pict fromMovie(Movie movie) throws QTException {
        int n = Pict.GetMoviePosterPict(QTObject.ID(movie));
        StdQTException.checkError(Pict.GetMoviesError());
        return new Pict(n);
    }

    public static Pict fromPresentation(Presentation presentation, Stream stream) throws QTException {
        int[] nArray = new int[1];
        StdQTException.checkError(Pict.QTSPresGetPicture(QTObject.ID(presentation), QTObject.ID(stream), nArray));
        return nArray[0] == 0 ? null : new Pict(nArray[0]);
    }

    public static Pict fromSequenceGrabber(SequenceGrabber sequenceGrabber, QDRect qDRect, int n, int n2) throws QTException {
        int[] nArray = new int[1];
        int n3 = Pict.SGGrabPict(QTObject.ID(sequenceGrabber), nArray, qDRect.getRect(), (short)n, n2);
        StdQTException.checkError(n3);
        return nArray[0] == 0 ? null : new Pict(nArray[0]);
    }

    public static Pict fromGraphicsImporter(GraphicsImporter graphicsImporter) throws QTException {
        int[] nArray = new int[]{0};
        int n = Pict.GraphicsImportGetAsPicture(QTObject.ID(graphicsImporter), nArray);
        StdQTException.checkError(n);
        return new Pict(nArray[0]);
    }

    public static Pict fromGraphicsExporter(GraphicsExporter graphicsExporter) throws QTException {
        int[] nArray = new int[]{0};
        int n = Pict.GraphicsExportGetInputPicture(QTObject.ID(graphicsExporter), nArray);
        StdQTException.checkError(n);
        return new Pict(nArray[0]);
    }

    public static Pict fromImageCompressionDialog(ImageCompressionDialog imageCompressionDialog, Pict pict) throws QTException {
        Pict pict2 = new Pict(4, true);
        int n = Pict.SCCompressPicture(QTObject.ID(imageCompressionDialog), QTObject.ID(pict), QTObject.ID(pict2));
        if (n == 1) {
            throw new StdQTException(-128);
        }
        StdQTException.checkError(n);
        return pict2;
    }

    public static Pict fromFile(File file) throws QTException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[fileInputStream.available() - 512];
        fileInputStream.skip(512L);
        fileInputStream.read(byArray, 0, byArray.length);
        fileInputStream.close();
        Pict pict = new Pict(byArray.length, false);
        pict.copyFromArray(0, byArray, 0, byArray.length);
        return pict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pict open(QDGraphics qDGraphics, OpenCPicParams openCPicParams) throws QTException {
        if (gw != null) {
            throw new QDException(-9);
        }
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Pict.GetGWorld(savedPort, savedDevice);
            }
            Pict.SetGWorld(QTObject.ID(qDGraphics), 0);
            gw = qDGraphics;
            n = Pict.OpenCPicture(openCPicParams.getBytes());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Pict.SetGWorld(savedPort[0], savedDevice[0]);
            }
            try {
                QDException.checkError(Pict.QDError());
            }
            catch (QTException qTException) {
                gw = null;
                throw qTException;
            }
        }
        if (n == 0) {
            throw new QDException(-108);
        }
        return new Pict(n);
    }

    public Pict(byte[] byArray) throws QTException {
        super(byArray.length, false);
        this.copyFromArray(0, byArray, 0, byArray.length);
    }

    private Pict(int n) throws QTException {
        super(n, null, false);
    }

    private Pict(int n, boolean bl) throws QTException {
        super(n, bl);
    }

    public QDRect getPictFrame() {
        byte[] byArray = new byte[8];
        this.getBytesAt(2, 8, byArray, 0);
        if (QTSession.isCurrentOS(2)) {
            for (int i = 0; i < 8; i += 2) {
                Pict.setShortInArray(byArray, i, EndianOrder.flipNativeToBigEndian16(Pict.getShortFromArray(byArray, i)));
            }
        }
        return QDRect.fromArray(byArray, 8);
    }

    public boolean isOpen() {
        return gw != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws QDException {
        if (gw != null) {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    Pict.GetGWorld(savedPort, savedDevice);
                }
                Pict.SetGWorld(QTObject.ID(gw), 0);
                Pict.ClosePicture();
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    Pict.SetGWorld(savedPort[0], savedDevice[0]);
                }
            }
        }
        gw = null;
    }

    public Pict compress(int n, int n2) throws QTException {
        if (this.isOpen()) {
            throw new QDException(-9);
        }
        Pict pict = new Pict(4, true);
        QDException.checkError(Pict.CompressPicture(this._ID(), QTObject.ID(pict), n, n2));
        return pict;
    }

    public Pict fCompress(int n, int n2, int n3, int n4, int n5, int n6) throws QTException {
        if (this.isOpen()) {
            throw new QDException(-9);
        }
        Pict pict = new Pict(4, true);
        QDException.checkError(Pict.FCompressPicture(this._ID(), QTObject.ID(pict), (short)n, 0, n2, (short)n3, (short)n4, 0, n5, n6));
        return pict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(QDGraphics qDGraphics, QDRect qDRect) throws QTException {
        if (this.isOpen()) {
            throw new QDException(-9);
        }
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Pict.GetGWorld(savedPort, savedDevice);
            }
            Pict.SetGWorld(QTObject.ID(qDGraphics), 0);
            Pict.DrawPicture(this._ID(), qDRect.getBytes());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Pict.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        QDException.checkError(Pict.QDError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTrimmed(QDGraphics qDGraphics, QDRect qDRect, Region region, int n) throws QTException {
        if (this.isOpen()) {
            throw new QDException(-9);
        }
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Pict.GetGWorld(savedPort, savedDevice);
            }
            Pict.SetGWorld(QTObject.ID(qDGraphics), 0);
            s = Pict.DrawTrimmedPicture(this._ID(), qDRect.getBytes(), QTObject.ID(region), (short)n, 0);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Pict.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        QDException.checkError(s);
    }

    public Pict makeThumbnail(int n) throws QTException {
        if (this.isOpen()) {
            throw new QDException(-9);
        }
        Pict pict = new Pict(4, false);
        QDException.checkError(Pict.MakeThumbnailFromPicture(this._ID(), (short)n, QTObject.ID(pict), 0));
        return pict;
    }

    public RawEncodedImage toEncodedImage() throws QDException {
        if (this.isOpen()) {
            throw new QDException(-9);
        }
        return RawEncodedImage.fromQTHandle(this);
    }

    public void writeToFile(File file) throws QDException, IOException {
        if (this.isOpen()) {
            throw new QDException(-9);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(new byte[512]);
        byte[] byArray = this.getBytes();
        fileOutputStream.write(byArray, 0, byArray.length);
        fileOutputStream.close();
    }

    public String toString() {
        return super.toString() + "[pictFrame=" + this.getPictFrame() + ",isOpen=" + this.isOpen() + "]";
    }

    protected void _dispose() {
        try {
            this.close();
        }
        catch (QDException qDException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qDException), this, "close");
        }
    }

    private static native int GetGWorldPixMap(int var0);

    private static native byte LockPixels(int var0);

    private static native short MakeThumbnailFromPixMap(int var0, byte[] var1, short var2, int var3, int var4);

    private static native void UnlockPixels(int var0);

    private static native int GetTrackPict(int var0, int var1);

    private static native short GetMoviesError();

    private static native int GetMoviePict(int var0, int var1);

    private static native int GetMoviePosterPict(int var0);

    private static native int SGGrabPict(int var0, int[] var1, byte[] var2, short var3, int var4);

    private static native int GraphicsImportGetAsPicture(int var0, int[] var1);

    private static native int SCCompressPicture(int var0, int var1, int var2);

    private static native int OpenCPicture(byte[] var0);

    private static native short QDError();

    private static native void ClosePicture();

    private static native short CompressPicture(int var0, int var1, int var2, int var3);

    private static native short FCompressPicture(int var0, int var1, short var2, int var3, int var4, short var5, short var6, int var7, int var8, int var9);

    private static native void DrawPicture(int var0, byte[] var1);

    private static native short DrawTrimmedPicture(int var0, byte[] var1, int var2, short var3, int var4);

    private static native short MakeThumbnailFromPicture(int var0, int var1, int var2, int var3);

    private static native int GraphicsExportGetInputPicture(int var0, int[] var1);

    private static native void SetGWorld(int var0, int var1);

    private static native void GetGWorld(int[] var0, int[] var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native short QTSPresGetPicture(int var0, int var1, int[] var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd$Pict == null ? (class$quicktime$qd$Pict = Pict.class$("quicktime.qd.Pict")) : class$quicktime$qd$Pict);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        kNativeSize = 10;
        gw = null;
        savedPort = new int[]{0};
        savedDevice = new int[]{0};
    }
}

